/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import jakarta.xml.bind.JAXBException;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.P;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingHyperlinkResolver {
    private static Logger log = LoggerFactory.getLogger(BindingHyperlinkResolver.class);
    private String hyperlinkStyleId = null;

    public void setHyperlinkStyle(String hyperlinkStyleID) {
        this.hyperlinkStyleId = hyperlinkStyleID;
    }

    public String getHyperlinkStyleId() {
        return this.hyperlinkStyleId;
    }

    public int getIndexOfURL(String text) {
        log.debug("processing " + text);
        int NOT_FOUND = 99999;
        int pos1 = text.indexOf("http://") == -1 ? NOT_FOUND : text.indexOf("http://");
        int pos2 = text.indexOf("https://") == -1 ? NOT_FOUND : text.indexOf("https://");
        int pos3 = text.indexOf("mailto:") == -1 ? NOT_FOUND : text.indexOf("mailto:");
        int pos = Math.min(pos1, Math.min(pos2, pos3));
        if (pos == NOT_FOUND) {
            return -1;
        }
        return pos;
    }

    public P.Hyperlink generateHyperlink(String relId, String url) throws JAXBException {
        String hpl = "<w:hyperlink r:id=\"" + relId + "\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" ><w:r><w:rPr><w:rStyle w:val=\"" + this.getHyperlinkStyleId() + "\" /></w:rPr><w:t>" + url + "</w:t></w:r></w:hyperlink>";
        return (P.Hyperlink)XmlUtils.unmarshalString(hpl);
    }

    public void activateHyperlinkStyle(WordprocessingMLPackage wordMLPackage) {
        if (this.hyperlinkStyleId != null) {
            wordMLPackage.getMainDocumentPart().getPropertyResolver().activateStyle(this.getHyperlinkStyleId());
        }
    }
}

