/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.PatternDescr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeFieldDescr
extends BaseDescr
implements Comparable<TypeFieldDescr> {
    private static final long serialVersionUID = 510L;
    private String fieldName;
    private String initExpr;
    private PatternDescr pattern;
    private Map<String, Map<String, String>> metaAttributes;
    private int index = -1;

    public TypeFieldDescr() {
        this(null);
    }

    public TypeFieldDescr(String fieldName) {
        this.fieldName = fieldName;
        this.metaAttributes = new HashMap<String, Map<String, String>>();
    }

    public TypeFieldDescr(String fieldName, PatternDescr pat) {
        this(fieldName);
        this.pattern = pat;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void addMetaAttribute(String attr, Map<String, String> value) {
        this.metaAttributes.put(attr, value);
    }

    public void addMetaAttribute(String attr, String value) {
        if (this.metaAttributes == null) {
            this.metaAttributes = new HashMap<String, Map<String, String>>();
        }
        Hashtable<String, String> attrMap = new Hashtable<String, String>();
        attrMap.put(value, value);
        this.metaAttributes.put(attr, attrMap);
    }

    public String getMetaAttribute(String attr) {
        if (this.metaAttributes == null) {
            return null;
        }
        Map<String, String> meta = this.metaAttributes.get(attr);
        return meta == null ? null : meta.keySet().iterator().next();
    }

    public Set<String> getMetaAttributes(String attr) {
        if (this.metaAttributes == null) {
            return null;
        }
        Map<String, String> meta = this.metaAttributes.get(attr);
        return meta == null ? null : meta.keySet();
    }

    public String getMetaAttributeValue(String attr, String key) {
        if (this.metaAttributes == null) {
            return null;
        }
        Map<String, String> meta = this.metaAttributes.get(attr);
        return meta == null ? null : meta.get(key);
    }

    public Map<String, String> getMetaAttributeValues(String attr) {
        if (this.metaAttributes == null) {
            return null;
        }
        return this.metaAttributes.get(attr);
    }

    public Map<String, Map<String, String>> getMetaAttributes() {
        return this.metaAttributes != null ? this.metaAttributes : Collections.EMPTY_MAP;
    }

    public String getInitExpr() {
        return this.initExpr;
    }

    public void setInitExpr(String initExpr) {
        this.initExpr = initExpr;
    }

    public PatternDescr getPattern() {
        return this.pattern;
    }

    public void setPattern(PatternDescr pattern) {
        this.pattern = pattern;
    }

    public String toString() {
        return "TypeField[ " + this.getFieldName() + " = (" + this.initExpr + ") : " + this.pattern + " ]";
    }

    @Override
    public int compareTo(TypeFieldDescr other) {
        return this.index - other.index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

