/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.ruleunit;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.ruleunit.RuleUnitDescr;
import org.drools.core.ruleunit.RuleUnitUtil;
import org.kie.api.runtime.rule.RuleUnit;
import org.kie.soup.project.datamodel.commons.types.TypeResolver;

public class RuleUnitRegistry {
    private State state = State.UNKNOWN;
    private final transient TypeResolver typeResolver;
    private final Map<String, RuleUnitDescr> ruleUnits = new ConcurrentHashMap<String, RuleUnitDescr>();
    private final Set<String> nonExistingUnits = new HashSet<String>();

    public RuleUnitRegistry() {
        this(null);
    }

    public RuleUnitRegistry(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public RuleUnitDescr getRuleUnitDescr(RuleUnit ruleUnit) {
        RuleUnitDescr ruleUnitDescr = this.ruleUnits.get(RuleUnitUtil.getUnitName(ruleUnit));
        if (ruleUnitDescr == null) {
            throw new IllegalStateException("Unknown RuleUnit: " + RuleUnitUtil.getUnitName(ruleUnit));
        }
        return ruleUnitDescr;
    }

    public Optional<RuleUnitDescr> getRuleUnitFor(RuleImpl rule) {
        String unitClassName = rule.getRuleUnitClassName();
        this.state = this.state.hasUnit(unitClassName != null);
        return Optional.ofNullable(unitClassName).map(name -> this.ruleUnits.computeIfAbsent((String)name, this::findRuleUnitDescr));
    }

    public Optional<RuleUnitDescr> getNamedRuleUnit(String ruleUnitName) {
        return this.ruleUnits != null ? Optional.of(this.ruleUnits.get(ruleUnitName)) : Optional.empty();
    }

    private RuleUnitDescr findRuleUnitDescr(String ruleUnit) {
        if (this.nonExistingUnits.contains(ruleUnit)) {
            return null;
        }
        try {
            return new RuleUnitDescr(this.typeResolver.resolveType(ruleUnit));
        }
        catch (ClassNotFoundException e) {
            this.nonExistingUnits.add(ruleUnit);
            return null;
        }
    }

    public void registerRuleUnit(String unitName, Supplier<Class<? extends RuleUnit>> unitSupplier) {
        this.ruleUnits.computeIfAbsent(unitName, n -> new RuleUnitDescr((Class)unitSupplier.get()));
    }

    public void add(RuleUnitRegistry other) {
        if (other != null) {
            this.ruleUnits.putAll(other.ruleUnits);
            this.state = this.state.merge(other.state);
            this.nonExistingUnits.addAll(other.nonExistingUnits);
        }
    }

    public boolean hasUnits() {
        return !this.ruleUnits.isEmpty();
    }

    private static enum State {
        UNIT,
        NO_UNIT,
        UNKNOWN;


        State hasUnit(boolean hasUnit) {
            if (hasUnit) {
                if (this == NO_UNIT) {
                    throw new IllegalStateException("Cannot mix rules with and without unit");
                }
                return UNIT;
            }
            if (this == UNIT) {
                throw new IllegalStateException("Cannot mix rules with and without unit");
            }
            return NO_UNIT;
        }

        State merge(State other) {
            if (this == UNKNOWN) {
                return other;
            }
            if (other == UNKNOWN) {
                return this;
            }
            if (this != other) {
                throw new IllegalStateException("Cannot mix rules with and without unit");
            }
            return this;
        }
    }
}

