/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.ActivationListenerFactory;
import org.drools.core.BaseConfiguration;
import org.drools.core.QueryActivationListenerFactory;
import org.drools.core.RuleActivationListenerFactory;
import org.drools.core.rule.consequence.ConflictResolver;
import org.drools.core.runtime.rule.impl.DefaultConsequenceExceptionHandler;
import org.drools.util.StringUtils;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.BetaRangeIndexOption;
import org.kie.api.conf.ConfigurationKey;
import org.kie.api.conf.DeclarativeAgendaOption;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.MultiValueKieBaseOption;
import org.kie.api.conf.Option;
import org.kie.api.conf.OptionKey;
import org.kie.api.conf.RemoveIdentitiesOption;
import org.kie.api.conf.SequentialOption;
import org.kie.api.conf.SessionsPoolOption;
import org.kie.api.conf.SingleValueKieBaseOption;
import org.kie.internal.conf.AlphaRangeIndexThresholdOption;
import org.kie.internal.conf.AlphaThresholdOption;
import org.kie.internal.conf.CompositeConfiguration;
import org.kie.internal.conf.CompositeKeyDepthOption;
import org.kie.internal.conf.ConsequenceExceptionHandlerOption;
import org.kie.internal.conf.ConstraintJittingThresholdOption;
import org.kie.internal.conf.IndexLeftBetaMemoryOption;
import org.kie.internal.conf.IndexPrecedenceOption;
import org.kie.internal.conf.IndexRightBetaMemoryOption;
import org.kie.internal.conf.MaxThreadsOption;
import org.kie.internal.conf.MultithreadEvaluationOption;
import org.kie.internal.conf.SequentialAgendaOption;
import org.kie.internal.conf.ShareAlphaNodesOption;
import org.kie.internal.conf.ShareBetaNodesOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBaseConfiguration
extends BaseConfiguration<KieBaseOption, SingleValueKieBaseOption, MultiValueKieBaseOption>
implements KieBaseConfiguration,
Externalizable {
    public static final ConfigurationKey<RuleBaseConfiguration> KEY = new ConfigurationKey("Rule");
    private static final long serialVersionUID = 510L;
    public static final boolean DEFAULT_PHREAK = true;
    public static final boolean DEFAULT_SESSION_CACHE = true;
    public static final String DEFAULT_SIGN_ON_SERIALIZATION = "false";
    protected static final transient Logger logger = LoggerFactory.getLogger(RuleBaseConfiguration.class);
    private boolean sequential;
    private SequentialAgenda sequentialAgenda;
    private boolean maintainTms;
    private boolean removeIdentities;
    private boolean shareAlphaNodes;
    private boolean shareBetaNodes;
    private int permGenThreshold;
    private int jittingThreshold;
    private int alphaNodeHashingThreshold;
    private int alphaNodeRangeIndexThreshold;
    private boolean betaNodeRangeIndexEnabled;
    private int compositeKeyDepth;
    private boolean indexLeftBetaMemory;
    private boolean indexRightBetaMemory;
    private AssertBehaviour assertBehaviour;
    private String consequenceExceptionHandler;
    private String ruleBaseUpdateHandler;
    private boolean declarativeAgenda;
    private EventProcessingOption eventProcessingMode;
    private IndexPrecedenceOption indexPrecedenceOption;
    private boolean multithread;
    private int maxThreads;
    private ConflictResolver conflictResolver;
    private Map<String, ActivationListenerFactory> activationListeners;
    private int sessionPoolSize;

    public RuleBaseConfiguration(CompositeConfiguration<KieBaseOption, SingleValueKieBaseOption, MultiValueKieBaseOption> compConfig) {
        super(compConfig);
        this.init();
    }

    private void init() {
        this.setRemoveIdentities(Boolean.parseBoolean(this.getPropertyValue("drools.removeIdentities", DEFAULT_SIGN_ON_SERIALIZATION)));
        this.setShareAlphaNodes(Boolean.parseBoolean(this.getPropertyValue("drools.shareAlphaNodes", "true")));
        this.setShareBetaNodes(Boolean.parseBoolean(this.getPropertyValue("drools.shareBetaNodes", "true")));
        this.setJittingThreshold(Integer.parseInt(this.getPropertyValue("drools.jittingThreshold", "20")));
        this.setAlphaNodeHashingThreshold(Integer.parseInt(this.getPropertyValue("drools.alphaNodeHashingThreshold", "3")));
        this.setAlphaNodeRangeIndexThreshold(Integer.parseInt(this.getPropertyValue("drools.alphaNodeRangeIndexThreshold", "9")));
        this.setBetaNodeRangeIndexEnabled(Boolean.parseBoolean(this.getPropertyValue("drools.betaNodeRangeIndexEnabled", DEFAULT_SIGN_ON_SERIALIZATION)));
        this.setSessionPoolSize(Integer.parseInt(this.getPropertyValue("drools.sessionPool", "-1")));
        this.setCompositeKeyDepth(Integer.parseInt(this.getPropertyValue("drools.compositeKeyDepth", "3")));
        this.setIndexLeftBetaMemory(Boolean.parseBoolean(this.getPropertyValue("drools.indexLeftBetaMemory", "true")));
        this.setIndexRightBetaMemory(Boolean.parseBoolean(this.getPropertyValue("drools.indexRightBetaMemory", "true")));
        this.setIndexPrecedenceOption(IndexPrecedenceOption.determineIndexPrecedence((String)this.getPropertyValue("drools.indexPrecedence", "equality")));
        this.setAssertBehaviour(AssertBehaviour.determineAssertBehaviour(this.getPropertyValue("drools.equalityBehavior", "identity")));
        this.setConsequenceExceptionHandler(this.getPropertyValue("drools.consequenceExceptionHandler", "org.drools.core.runtime.rule.impl.DefaultConsequenceExceptionHandler"));
        this.setRuleBaseUpdateHandler(this.getPropertyValue("drools.ruleBaseUpdateHandler", ""));
        this.setSequentialAgenda(SequentialAgenda.determineSequentialAgenda(this.getPropertyValue("drools.sequential.agenda", "sequential")));
        this.setSequential(Boolean.parseBoolean(this.getPropertyValue("drools.sequential", DEFAULT_SIGN_ON_SERIALIZATION)));
        this.setMultithreadEvaluation(Boolean.parseBoolean(this.getPropertyValue("drools.multithreadEvaluation", DEFAULT_SIGN_ON_SERIALIZATION)));
        this.setMaxThreads(Integer.parseInt(this.getPropertyValue("drools.maxThreads", "3")));
        this.setEventProcessingMode(EventProcessingOption.determineEventProcessingMode((String)this.getPropertyValue("drools.eventProcessingMode", "cloud")));
        this.setDeclarativeAgendaEnabled(Boolean.parseBoolean(this.getPropertyValue("drools.declarativeAgendaEnabled", DEFAULT_SIGN_ON_SERIALIZATION)));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.sequential);
        out.writeObject(this.sequentialAgenda);
        out.writeBoolean(this.maintainTms);
        out.writeBoolean(this.removeIdentities);
        out.writeBoolean(this.shareAlphaNodes);
        out.writeBoolean(this.shareBetaNodes);
        out.writeInt(this.permGenThreshold);
        out.writeInt(this.jittingThreshold);
        out.writeInt(this.alphaNodeHashingThreshold);
        out.writeInt(this.alphaNodeRangeIndexThreshold);
        out.writeBoolean(this.betaNodeRangeIndexEnabled);
        out.writeInt(this.compositeKeyDepth);
        out.writeBoolean(this.indexLeftBetaMemory);
        out.writeBoolean(this.indexRightBetaMemory);
        out.writeObject(this.indexPrecedenceOption);
        out.writeObject(this.assertBehaviour);
        out.writeObject(this.consequenceExceptionHandler);
        out.writeObject(this.ruleBaseUpdateHandler);
        out.writeObject(this.conflictResolver);
        out.writeBoolean(this.multithread);
        out.writeInt(this.maxThreads);
        out.writeObject(this.eventProcessingMode);
        out.writeBoolean(this.declarativeAgenda);
        out.writeInt(this.sessionPoolSize);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sequential = in.readBoolean();
        this.sequentialAgenda = (SequentialAgenda)in.readObject();
        this.maintainTms = in.readBoolean();
        this.removeIdentities = in.readBoolean();
        this.shareAlphaNodes = in.readBoolean();
        this.shareBetaNodes = in.readBoolean();
        this.permGenThreshold = in.readInt();
        this.jittingThreshold = in.readInt();
        this.alphaNodeHashingThreshold = in.readInt();
        this.alphaNodeRangeIndexThreshold = in.readInt();
        this.betaNodeRangeIndexEnabled = in.readBoolean();
        this.compositeKeyDepth = in.readInt();
        this.indexLeftBetaMemory = in.readBoolean();
        this.indexRightBetaMemory = in.readBoolean();
        this.indexPrecedenceOption = (IndexPrecedenceOption)in.readObject();
        this.assertBehaviour = (AssertBehaviour)in.readObject();
        this.consequenceExceptionHandler = (String)in.readObject();
        this.ruleBaseUpdateHandler = (String)in.readObject();
        this.conflictResolver = (ConflictResolver)in.readObject();
        this.multithread = in.readBoolean();
        this.maxThreads = in.readInt();
        this.eventProcessingMode = (EventProcessingOption)in.readObject();
        this.declarativeAgenda = in.readBoolean();
        this.sessionPoolSize = in.readInt();
    }

    public <T extends SingleValueKieBaseOption> T getOption(OptionKey<T> option) {
        switch (option.name()) {
            case "drools.sequential": {
                return (T)(this.sequential ? SequentialOption.YES : SequentialOption.NO);
            }
            case "drools.removeIdentities": {
                return (T)(this.removeIdentities ? RemoveIdentitiesOption.YES : RemoveIdentitiesOption.NO);
            }
            case "drools.shareAlphaNodes": {
                return (T)(this.shareAlphaNodes ? ShareAlphaNodesOption.YES : ShareAlphaNodesOption.NO);
            }
            case "drools.shareBetaNodes": {
                return (T)(this.shareBetaNodes ? ShareBetaNodesOption.YES : ShareBetaNodesOption.NO);
            }
            case "drools.indexRightBetaMemory": {
                return (T)(this.indexRightBetaMemory ? IndexRightBetaMemoryOption.YES : IndexRightBetaMemoryOption.NO);
            }
            case "drools.indexLeftBetaMemory": {
                return (T)(this.indexLeftBetaMemory ? IndexLeftBetaMemoryOption.YES : IndexLeftBetaMemoryOption.NO);
            }
            case "drools.indexPrecedence": {
                return (T)this.getIndexPrecedenceOption();
            }
            case "drools.equalityBehavior": {
                return (T)(this.assertBehaviour == AssertBehaviour.IDENTITY ? EqualityBehaviorOption.IDENTITY : EqualityBehaviorOption.EQUALITY);
            }
            case "drools.sequential.agenda": {
                return (T)(this.sequentialAgenda == SequentialAgenda.SEQUENTIAL ? SequentialAgendaOption.SEQUENTIAL : SequentialAgendaOption.DYNAMIC);
            }
            case "drools.jittingThreshold": {
                return (T)ConstraintJittingThresholdOption.get((int)this.jittingThreshold);
            }
            case "drools.alphaNodeHashingThreshold": {
                return (T)AlphaThresholdOption.get((int)this.alphaNodeHashingThreshold);
            }
            case "drools.alphaNodeRangeIndexThreshold": {
                return (T)AlphaRangeIndexThresholdOption.get((int)this.alphaNodeRangeIndexThreshold);
            }
            case "drools.betaNodeRangeIndexEnabled": {
                return (T)(this.betaNodeRangeIndexEnabled ? BetaRangeIndexOption.ENABLED : BetaRangeIndexOption.DISABLED);
            }
            case "drools.sessionPool": {
                return (T)SessionsPoolOption.get((int)this.sessionPoolSize);
            }
            case "drools.compositeKeyDepth": {
                return (T)CompositeKeyDepthOption.get((int)this.compositeKeyDepth);
            }
            case "drools.consequenceExceptionHandler": {
                Class<?> handler;
                try {
                    handler = Class.forName(this.consequenceExceptionHandler);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Unable to resolve ConsequenceExceptionHandler class: " + this.consequenceExceptionHandler, e);
                }
                return (T)ConsequenceExceptionHandlerOption.get(handler);
            }
            case "drools.eventProcessingMode": {
                return (T)this.getEventProcessingMode();
            }
            case "drools.maxThreads": {
                return (T)MaxThreadsOption.get((int)this.getMaxThreads());
            }
            case "drools.multithreadEvaluation": {
                return (T)(this.multithread ? MultithreadEvaluationOption.YES : MultithreadEvaluationOption.NO);
            }
            case "drools.declarativeAgendaEnabled": {
                return (T)(this.isDeclarativeAgenda() ? DeclarativeAgendaOption.ENABLED : DeclarativeAgendaOption.DISABLED);
            }
        }
        return (T)((SingleValueKieBaseOption)this.compConfig.getOption(option));
    }

    public void setOption(KieBaseOption option) {
        switch (option.propertyName()) {
            case "drools.sequential": {
                this.setSequential(((SequentialOption)option).isSequential());
                break;
            }
            case "drools.removeIdentities": {
                this.setRemoveIdentities(((RemoveIdentitiesOption)option).isRemoveIdentities());
                break;
            }
            case "drools.shareAlphaNodes": {
                this.setShareAlphaNodes(((ShareAlphaNodesOption)option).isShareAlphaNodes());
                break;
            }
            case "drools.shareBetaNodes": {
                this.setShareBetaNodes(((ShareBetaNodesOption)option).isShareBetaNodes());
                break;
            }
            case "drools.indexLeftBetaMemory": {
                this.setIndexLeftBetaMemory(((IndexLeftBetaMemoryOption)option).isIndexLeftBetaMemory());
                break;
            }
            case "drools.indexRightBetaMemory": {
                this.setIndexRightBetaMemory(((IndexRightBetaMemoryOption)option).isIndexRightBetaMemory());
                break;
            }
            case "drools.indexPrecedence": {
                this.setIndexPrecedenceOption((IndexPrecedenceOption)option);
                break;
            }
            case "drools.equalityBehavior": {
                this.setAssertBehaviour(option == EqualityBehaviorOption.IDENTITY ? AssertBehaviour.IDENTITY : AssertBehaviour.EQUALITY);
                break;
            }
            case "drools.sequential.agenda": {
                this.setSequentialAgenda(option == SequentialAgendaOption.SEQUENTIAL ? SequentialAgenda.SEQUENTIAL : SequentialAgenda.DYNAMIC);
                break;
            }
            case "drools.jittingThreshold": {
                this.setJittingThreshold(((ConstraintJittingThresholdOption)option).getThreshold());
                break;
            }
            case "drools.alphaNodeHashingThreshold": {
                this.setAlphaNodeHashingThreshold(((AlphaThresholdOption)option).getThreshold());
                break;
            }
            case "drools.alphaNodeRangeIndexThreshold": {
                this.setAlphaNodeRangeIndexThreshold(((AlphaRangeIndexThresholdOption)option).getThreshold());
                break;
            }
            case "drools.betaNodeRangeIndexEnabled": {
                this.setBetaNodeRangeIndexEnabled(((BetaRangeIndexOption)option).isBetaRangeIndexEnabled());
                break;
            }
            case "drools.sessionPool": {
                this.setSessionPoolSize(((SessionsPoolOption)option).getSize());
                break;
            }
            case "drools.compositeKeyDepth": {
                this.setCompositeKeyDepth(((CompositeKeyDepthOption)option).getDepth());
                break;
            }
            case "drools.consequenceExceptionHandler": {
                this.setConsequenceExceptionHandler(((ConsequenceExceptionHandlerOption)option).getHandler().getName());
                break;
            }
            case "drools.eventProcessingMode": {
                this.setEventProcessingMode((EventProcessingOption)option);
                break;
            }
            case "drools.maxThreads": {
                this.setMaxThreads(((MaxThreadsOption)option).getMaxThreads());
                break;
            }
            case "drools.multithreadEvaluation": {
                this.setMultithreadEvaluation(((MultithreadEvaluationOption)option).isMultithreadEvaluation());
                break;
            }
            case "drools.declarativeAgendaEnabled": {
                this.setDeclarativeAgendaEnabled(((DeclarativeAgendaOption)option).isDeclarativeAgendaEnabled());
                break;
            }
            default: {
                this.compConfig.setOption((Option)option);
            }
        }
    }

    public boolean setInternalProperty(String name, String value) {
        switch (name) {
            case "drools.sequential.agenda": {
                this.setSequentialAgenda(SequentialAgenda.determineSequentialAgenda(StringUtils.isEmpty((CharSequence)value) ? "sequential" : value));
                break;
            }
            case "drools.sequential": {
                this.setSequential(StringUtils.isEmpty((CharSequence)value) ? false : Boolean.valueOf(value));
                break;
            }
            case "drools.removeIdentities": {
                this.setRemoveIdentities(StringUtils.isEmpty((CharSequence)value) ? false : Boolean.valueOf(value));
                break;
            }
            case "drools.shareAlphaNodes": {
                this.setShareAlphaNodes(StringUtils.isEmpty((CharSequence)value) ? false : Boolean.valueOf(value));
                break;
            }
            case "drools.shareBetaNodes": {
                this.setShareBetaNodes(StringUtils.isEmpty((CharSequence)value) ? false : Boolean.valueOf(value));
                break;
            }
            case "drools.jittingThreshold": {
                this.setJittingThreshold(StringUtils.isEmpty((CharSequence)value) ? 20 : Integer.parseInt(value));
                break;
            }
            case "drools.alphaNodeHashingThreshold": {
                this.setAlphaNodeHashingThreshold(StringUtils.isEmpty((CharSequence)value) ? 3 : Integer.parseInt(value));
                break;
            }
            case "drools.alphaNodeRangeIndexThreshold": {
                this.setAlphaNodeRangeIndexThreshold(StringUtils.isEmpty((CharSequence)value) ? 9 : Integer.parseInt(value));
                break;
            }
            case "drools.betaNodeRangeIndexEnabled": {
                this.setBetaNodeRangeIndexEnabled(StringUtils.isEmpty((CharSequence)value) ? false : Boolean.valueOf(value));
                break;
            }
            case "drools.sessionPool": {
                this.setSessionPoolSize(StringUtils.isEmpty((CharSequence)value) ? -1 : Integer.parseInt(value));
                break;
            }
            case "drools.compositeKeyDepth": {
                this.setCompositeKeyDepth(StringUtils.isEmpty((CharSequence)value) ? 3 : Integer.parseInt(value));
                break;
            }
            case "drools.indexLeftBetaMemory": {
                this.setIndexLeftBetaMemory(StringUtils.isEmpty((CharSequence)value) ? true : Boolean.valueOf(value));
                break;
            }
            case "drools.indexRightBetaMemory": {
                this.setIndexRightBetaMemory(StringUtils.isEmpty((CharSequence)value) ? true : Boolean.valueOf(value));
                break;
            }
            case "drools.indexPrecedence": {
                this.setIndexPrecedenceOption(StringUtils.isEmpty((CharSequence)value) ? IndexPrecedenceOption.EQUALITY_PRIORITY : IndexPrecedenceOption.determineIndexPrecedence((String)value));
                break;
            }
            case "drools.equalityBehavior": {
                this.setAssertBehaviour(AssertBehaviour.determineAssertBehaviour(StringUtils.isEmpty((CharSequence)value) ? "identity" : value));
                break;
            }
            case "drools.consequenceExceptionHandler": {
                this.setConsequenceExceptionHandler(StringUtils.isEmpty((CharSequence)value) ? DefaultConsequenceExceptionHandler.class.getName() : value);
                break;
            }
            case "drools.ruleBaseUpdateHandler": {
                this.setRuleBaseUpdateHandler(StringUtils.isEmpty((CharSequence)value) ? "" : value);
                break;
            }
            case "drools.multithreadEvaluation": {
                this.setMultithreadEvaluation(StringUtils.isEmpty((CharSequence)value) ? false : Boolean.valueOf(value));
                break;
            }
            case "drools.maxThreads": {
                this.setMaxThreads(StringUtils.isEmpty((CharSequence)value) ? 3 : Integer.parseInt(value));
                break;
            }
            case "drools.eventProcessingMode": {
                this.setEventProcessingMode(EventProcessingOption.determineEventProcessingMode((String)(StringUtils.isEmpty((CharSequence)value) ? "cloud" : value)));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public String getInternalProperty(String name) {
        switch (name) {
            case "drools.sequential.agenda": {
                return this.getSequentialAgenda().toExternalForm();
            }
            case "drools.sequential": {
                return Boolean.toString(this.isSequential());
            }
            case "drools.removeIdentities": {
                return Boolean.toString(this.isRemoveIdentities());
            }
            case "drools.shareAlphaNodes": {
                return Boolean.toString(this.isShareAlphaNodes());
            }
            case "drools.shareBetaNodes": {
                return Boolean.toString(this.isShareBetaNodes());
            }
            case "drools.jittingThreshold": {
                return Integer.toString(this.getJittingThreshold());
            }
            case "drools.alphaNodeHashingThreshold": {
                return Integer.toString(this.getAlphaNodeHashingThreshold());
            }
            case "drools.alphaNodeRangeIndexThreshold": {
                return Integer.toString(this.getAlphaNodeRangeIndexThreshold());
            }
            case "drools.betaNodeRangeIndexEnabled": {
                return Boolean.toString(this.isBetaNodeRangeIndexEnabled());
            }
            case "drools.sessionPool": {
                return Integer.toString(this.getSessionPoolSize());
            }
            case "drools.compositeKeyDepth": {
                return Integer.toString(this.getCompositeKeyDepth());
            }
            case "drools.indexLeftBetaMemory": {
                return Boolean.toString(this.isIndexLeftBetaMemory());
            }
            case "drools.indexRightBetaMemory": {
                return Boolean.toString(this.isIndexRightBetaMemory());
            }
            case "drools.indexPrecedence": {
                return this.getIndexPrecedenceOption().getValue();
            }
            case "drools.equalityBehavior": {
                return this.getAssertBehaviour().toExternalForm();
            }
            case "drools.consequenceExceptionHandler": {
                return this.getConsequenceExceptionHandler();
            }
            case "drools.ruleBaseUpdateHandler": {
                return this.getRuleBaseUpdateHandler();
            }
            case "drools.multithreadEvaluation": {
                return Boolean.toString(this.isMultithreadEvaluation());
            }
            case "drools.maxThreads": {
                return Integer.toString(this.getMaxThreads());
            }
            case "drools.eventProcessingMode": {
                return this.getEventProcessingMode().getMode();
            }
        }
        return null;
    }

    public void setSequential(boolean sequential) {
        this.sequential = sequential;
    }

    public boolean isSequential() {
        return this.sequential;
    }

    public boolean isMaintainTms() {
        return this.maintainTms;
    }

    public void setMaintainTms(boolean maintainTms) {
        this.checkCanChange();
        this.maintainTms = maintainTms;
    }

    public boolean isRemoveIdentities() {
        return this.removeIdentities;
    }

    public void setRemoveIdentities(boolean removeIdentities) {
        this.checkCanChange();
        this.removeIdentities = removeIdentities;
    }

    public boolean isShareAlphaNodes() {
        return this.shareAlphaNodes;
    }

    public void setShareAlphaNodes(boolean shareAlphaNodes) {
        this.checkCanChange();
        this.shareAlphaNodes = shareAlphaNodes;
    }

    public boolean isShareBetaNodes() {
        return this.shareBetaNodes;
    }

    public void setShareBetaNodes(boolean shareBetaNodes) {
        this.checkCanChange();
        this.shareBetaNodes = shareBetaNodes;
    }

    public int getJittingThreshold() {
        return this.jittingThreshold;
    }

    public void setJittingThreshold(int jittingThreshold) {
        this.checkCanChange();
        this.jittingThreshold = jittingThreshold;
    }

    public int getAlphaNodeHashingThreshold() {
        return this.alphaNodeHashingThreshold;
    }

    public void setAlphaNodeHashingThreshold(int alphaNodeHashingThreshold) {
        this.checkCanChange();
        this.alphaNodeHashingThreshold = alphaNodeHashingThreshold;
    }

    public int getAlphaNodeRangeIndexThreshold() {
        return this.alphaNodeRangeIndexThreshold;
    }

    public void setAlphaNodeRangeIndexThreshold(int alphaNodeRangeIndexThreshold) {
        this.checkCanChange();
        this.alphaNodeRangeIndexThreshold = alphaNodeRangeIndexThreshold;
    }

    public boolean isBetaNodeRangeIndexEnabled() {
        return this.betaNodeRangeIndexEnabled;
    }

    public void setBetaNodeRangeIndexEnabled(boolean betaNodeRangeIndexEnabled) {
        this.checkCanChange();
        this.betaNodeRangeIndexEnabled = betaNodeRangeIndexEnabled;
    }

    public int getSessionPoolSize() {
        return this.sessionPoolSize;
    }

    public void setSessionPoolSize(int sessionPoolSize) {
        this.checkCanChange();
        this.sessionPoolSize = sessionPoolSize;
    }

    public AssertBehaviour getAssertBehaviour() {
        return this.assertBehaviour;
    }

    public void setAssertBehaviour(AssertBehaviour assertBehaviour) {
        this.checkCanChange();
        this.assertBehaviour = assertBehaviour;
    }

    public EventProcessingOption getEventProcessingMode() {
        return this.eventProcessingMode;
    }

    public void setEventProcessingMode(EventProcessingOption mode) {
        this.checkCanChange();
        this.eventProcessingMode = mode;
    }

    public int getCompositeKeyDepth() {
        return this.compositeKeyDepth;
    }

    public void setCompositeKeyDepth(int compositeKeyDepth) {
        this.checkCanChange();
        if (compositeKeyDepth > 3) {
            throw new UnsupportedOperationException("compositeKeyDepth cannot be greater than 3");
        }
        this.compositeKeyDepth = compositeKeyDepth;
    }

    public boolean isIndexLeftBetaMemory() {
        return this.indexLeftBetaMemory;
    }

    public void setIndexLeftBetaMemory(boolean indexLeftBetaMemory) {
        this.checkCanChange();
        this.indexLeftBetaMemory = indexLeftBetaMemory;
    }

    public boolean isIndexRightBetaMemory() {
        return this.indexRightBetaMemory;
    }

    public void setIndexRightBetaMemory(boolean indexRightBetaMemory) {
        this.checkCanChange();
        this.indexRightBetaMemory = indexRightBetaMemory;
    }

    public IndexPrecedenceOption getIndexPrecedenceOption() {
        return this.indexPrecedenceOption;
    }

    public void setIndexPrecedenceOption(IndexPrecedenceOption precedence) {
        this.checkCanChange();
        this.indexPrecedenceOption = precedence;
    }

    public String getConsequenceExceptionHandler() {
        return this.consequenceExceptionHandler;
    }

    public void setConsequenceExceptionHandler(String consequenceExceptionHandler) {
        this.checkCanChange();
        this.consequenceExceptionHandler = consequenceExceptionHandler;
    }

    public String getRuleBaseUpdateHandler() {
        return this.ruleBaseUpdateHandler;
    }

    public void setRuleBaseUpdateHandler(String ruleBaseUpdateHandler) {
        this.checkCanChange();
        this.ruleBaseUpdateHandler = ruleBaseUpdateHandler;
    }

    public SequentialAgenda getSequentialAgenda() {
        return this.sequentialAgenda;
    }

    public void setSequentialAgenda(SequentialAgenda sequentialAgenda) {
        this.checkCanChange();
        this.sequentialAgenda = sequentialAgenda;
    }

    public void setMultithreadEvaluation(boolean enableMultithread) {
        this.checkCanChange();
        this.multithread = enableMultithread;
    }

    public void enforceSingleThreadEvaluation() {
        this.multithread = false;
    }

    public boolean isMultithreadEvaluation() {
        return this.multithread;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public boolean isDeclarativeAgenda() {
        return this.declarativeAgenda;
    }

    public void setDeclarativeAgendaEnabled(boolean enabled) {
        this.checkCanChange();
        this.declarativeAgenda = enabled;
    }

    public void addActivationListener(String name, ActivationListenerFactory factory) {
        if (this.activationListeners == null) {
            this.activationListeners = new HashMap<String, ActivationListenerFactory>();
        }
        this.activationListeners.put(name, factory);
    }

    public ActivationListenerFactory getActivationListenerFactory(String name) {
        ActivationListenerFactory factory = null;
        if (this.activationListeners != null) {
            factory = this.activationListeners.get(name);
        }
        if (factory != null) {
            return factory;
        }
        if ("query".equals(name)) {
            return QueryActivationListenerFactory.INSTANCE;
        }
        if ("agenda".equals(name) || "direct".equals(name)) {
            return RuleActivationListenerFactory.INSTANCE;
        }
        throw new IllegalArgumentException("ActivationListenerFactory not found for '" + name + "'");
    }

    public static class SequentialAgenda
    implements Externalizable {
        private static final long serialVersionUID = 510L;
        public static final SequentialAgenda SEQUENTIAL = new SequentialAgenda(0);
        public static final SequentialAgenda DYNAMIC = new SequentialAgenda(1);
        private int value;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.value = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.value);
        }

        public SequentialAgenda() {
        }

        private SequentialAgenda(int value) {
            this.value = value;
        }

        public static SequentialAgenda determineSequentialAgenda(String value) {
            if ("sequential".equalsIgnoreCase(value)) {
                return SEQUENTIAL;
            }
            if ("dynamic".equalsIgnoreCase(value)) {
                return DYNAMIC;
            }
            throw new IllegalArgumentException("Illegal enum value '" + value + "' for SequentialAgenda");
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.value) {
                case 0: {
                    return SEQUENTIAL;
                }
                case 1: {
                    return DYNAMIC;
                }
            }
            throw new IllegalArgumentException("Illegal enum value '" + this.value + "' for SequentialAgenda");
        }

        public String toExternalForm() {
            return this.value == 0 ? "sequential" : "dynamic";
        }

        public String toString() {
            return "SequentialAgenda : " + (this.value == 0 ? "sequential" : "dynamic");
        }
    }

    public static class AssertBehaviour
    implements Externalizable {
        private static final long serialVersionUID = 510L;
        public static final AssertBehaviour IDENTITY = new AssertBehaviour(0);
        public static final AssertBehaviour EQUALITY = new AssertBehaviour(1);
        private int value;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.value = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.value);
        }

        public AssertBehaviour() {
        }

        private AssertBehaviour(int value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof AssertBehaviour) {
                AssertBehaviour that = (AssertBehaviour)obj;
                return this.value == that.value;
            }
            return false;
        }

        public static AssertBehaviour determineAssertBehaviour(String value) {
            if ("IDENTITY".equalsIgnoreCase(value)) {
                return IDENTITY;
            }
            if ("EQUALITY".equalsIgnoreCase(value)) {
                return EQUALITY;
            }
            throw new IllegalArgumentException("Illegal enum value '" + value + "' for AssertBehaviour");
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.value) {
                case 0: {
                    return IDENTITY;
                }
                case 1: {
                    return EQUALITY;
                }
            }
            throw new IllegalArgumentException("Illegal enum value '" + this.value + "' for AssertBehaviour");
        }

        public String toExternalForm() {
            return this.value == 0 ? "identity" : "equality";
        }

        public String toString() {
            return "AssertBehaviour : " + (this.value == 0 ? "identity" : "equality");
        }
    }
}

