/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.debug;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.core.WorkingMemory;
import org.drools.core.common.NetworkNode;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.kiesession.debug.AccumulateNodeVisitor;
import org.drools.kiesession.debug.AlphaNodeVisitor;
import org.drools.kiesession.debug.BetaNodeVisitor;
import org.drools.kiesession.debug.DefaultNetworkNodeVisitor;
import org.drools.kiesession.debug.EvalConditionNodeVisitor;
import org.drools.kiesession.debug.FromNodeVisitor;
import org.drools.kiesession.debug.LeftInputAdapterNodeVisitor;
import org.drools.kiesession.debug.NetworkNodeVisitor;
import org.drools.kiesession.debug.ObjectTypeNodeVisitor;
import org.drools.kiesession.debug.QueryTerminalNodeVisitor;
import org.drools.kiesession.debug.RightInputAdapterNodeVisitor;
import org.drools.kiesession.debug.RuleTerminalNodeVisitor;
import org.drools.kiesession.debug.StatefulKnowledgeSessionInfo;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.kie.api.runtime.KieSession;

public class SessionInspector {
    private StatefulKnowledgeSessionImpl session;
    private Map<Short, NetworkNodeVisitor> visitors = new HashMap<Short, NetworkNodeVisitor>();

    public SessionInspector(KieSession session) {
        this.visitors.put((short)101, RuleTerminalNodeVisitor.INSTANCE);
        this.visitors.put((short)91, QueryTerminalNodeVisitor.INSTANCE);
        this.visitors.put((short)20, DefaultNetworkNodeVisitor.INSTANCE);
        this.visitors.put((short)10, DefaultNetworkNodeVisitor.INSTANCE);
        this.visitors.put((short)30, ObjectTypeNodeVisitor.INSTANCE);
        this.visitors.put((short)40, AlphaNodeVisitor.INSTANCE);
        this.visitors.put((short)71, RightInputAdapterNodeVisitor.INSTANCE);
        this.visitors.put((short)181, BetaNodeVisitor.INSTANCE);
        this.visitors.put((short)171, BetaNodeVisitor.INSTANCE);
        this.visitors.put((short)201, BetaNodeVisitor.INSTANCE);
        this.visitors.put((short)191, BetaNodeVisitor.INSTANCE);
        this.visitors.put((short)211, AccumulateNodeVisitor.INSTANCE);
        this.visitors.put((short)131, EvalConditionNodeVisitor.INSTANCE);
        this.visitors.put((short)151, FromNodeVisitor.INSTANCE);
        this.visitors.put((short)120, LeftInputAdapterNodeVisitor.INSTANCE);
        this.session = (StatefulKnowledgeSessionImpl)session;
    }

    public SessionInspector(WorkingMemory session) {
        this.visitors.put((short)101, RuleTerminalNodeVisitor.INSTANCE);
        this.visitors.put((short)91, QueryTerminalNodeVisitor.INSTANCE);
        this.visitors.put((short)20, DefaultNetworkNodeVisitor.INSTANCE);
        this.visitors.put((short)10, DefaultNetworkNodeVisitor.INSTANCE);
        this.visitors.put((short)30, ObjectTypeNodeVisitor.INSTANCE);
        this.visitors.put((short)40, AlphaNodeVisitor.INSTANCE);
        this.visitors.put((short)71, RightInputAdapterNodeVisitor.INSTANCE);
        this.visitors.put((short)181, BetaNodeVisitor.INSTANCE);
        this.visitors.put((short)171, BetaNodeVisitor.INSTANCE);
        this.visitors.put((short)201, BetaNodeVisitor.INSTANCE);
        this.visitors.put((short)191, BetaNodeVisitor.INSTANCE);
        this.visitors.put((short)211, AccumulateNodeVisitor.INSTANCE);
        this.visitors.put((short)131, EvalConditionNodeVisitor.INSTANCE);
        this.visitors.put((short)151, FromNodeVisitor.INSTANCE);
        this.visitors.put((short)120, LeftInputAdapterNodeVisitor.INSTANCE);
        this.session = (StatefulKnowledgeSessionImpl)session;
    }

    public StatefulKnowledgeSessionInfo getSessionInfo() {
        StatefulKnowledgeSessionInfo info = new StatefulKnowledgeSessionInfo();
        info.setSession(this.session);
        ArrayDeque<NetworkNode> nodeList = new ArrayDeque<NetworkNode>();
        this.gatherNodeInfo((NetworkNode)this.session.getKnowledgeBase().getRete(), nodeList, info);
        return info;
    }

    private void gatherNodeInfo(NetworkNode parent, Deque<NetworkNode> nodeList, StatefulKnowledgeSessionInfo info) {
        if (!info.visited(parent)) {
            nodeList.push(parent);
            NetworkNodeVisitor visitor = this.visitors.get(parent.getType());
            if (visitor == null) {
                throw new RuntimeException("No visitor found for node class: " + parent.getClass() + " node: " + parent);
            }
            visitor.visit(parent, nodeList, info);
            this.visitChildren(parent, nodeList, info);
            nodeList.pop();
        } else {
            Set<RuleImpl> rules = info.getNodeInfo(parent).getRules();
            for (NetworkNode snode : nodeList) {
                for (RuleImpl rule : rules) {
                    info.assign(snode, rule);
                }
            }
        }
    }

    protected void visitChildren(NetworkNode parent, Deque<NetworkNode> nodeStack, StatefulKnowledgeSessionInfo info) {
        if (parent instanceof Rete) {
            Rete rete = (Rete)parent;
            for (EntryPointNode sink : rete.getEntryPointNodes().values()) {
                this.gatherNodeInfo((NetworkNode)sink, nodeStack, info);
            }
        } else if (parent instanceof EntryPointNode) {
            EntryPointNode epn = (EntryPointNode)parent;
            for (ObjectTypeNode sink : epn.getObjectTypeNodes().values()) {
                this.gatherNodeInfo((NetworkNode)sink, nodeStack, info);
            }
        } else if (parent instanceof ObjectSource) {
            ObjectSource source = (ObjectSource)parent;
            for (ObjectSink sink : source.getObjectSinkPropagator().getSinks()) {
                this.gatherNodeInfo((NetworkNode)sink, nodeStack, info);
            }
        } else if (parent instanceof LeftTupleSource) {
            LeftTupleSource source = (LeftTupleSource)parent;
            for (LeftTupleSink sink : source.getSinkPropagator().getSinks()) {
                this.gatherNodeInfo((NetworkNode)sink, nodeStack, info);
            }
        } else if (!(parent instanceof RuleTerminalNode) && !(parent instanceof QueryTerminalNode)) {
            throw new RuntimeException("ERROR: No idea how to visit childrens of this node: " + parent);
        }
    }
}

