/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion.util;

public class CommaSeparatedListValueConverter {
    private final StringBuilder builder = new StringBuilder();
    private final char[] chars;
    boolean quoteOpen = false;
    boolean ignoreWhiteSpace = false;

    public CommaSeparatedListValueConverter(String value) {
        if (value.startsWith("\"")) {
            value = value.substring(1);
            this.quoteOpen = true;
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        this.chars = value.toCharArray();
    }

    public String convert() {
        this.builder.append("'");
        for (char aChar : this.chars) {
            if (this.ignoreWhiteSpace && !Character.isWhitespace(aChar)) {
                this.ignoreWhiteSpace = false;
            }
            if (this.ignoreWhiteSpace && Character.isWhitespace(aChar)) continue;
            if (aChar == '\"' && !this.quoteOpen) {
                this.quoteOpen = true;
                continue;
            }
            if (aChar == '\"' && this.quoteOpen) {
                this.quoteOpen = false;
                continue;
            }
            if (aChar == ',' && !this.quoteOpen) {
                this.builder.append("', '");
                this.ignoreWhiteSpace = true;
                continue;
            }
            if (aChar == '\'') {
                this.builder.append("\\'");
                continue;
            }
            this.builder.append(aChar);
        }
        this.builder.append("'");
        return this.builder.toString();
    }
}

