/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.commons.backend.rule.RuleModelDRLPersistenceImpl;
import org.drools.workbench.models.commons.backend.rule.RuleModelIActionPersistenceExtension;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.backend.server.GuidedRuleEditorServiceUtilities;
import org.drools.workbench.screens.guided.rule.backend.server.GuidedRuleModelVisitor;
import org.drools.workbench.screens.guided.rule.backend.server.RuleModelWrapper;
import org.drools.workbench.screens.guided.rule.model.GuidedEditorContent;
import org.drools.workbench.screens.guided.rule.service.GuidedRuleEditorService;
import org.drools.workbench.screens.guided.rule.type.GuidedRuleDRLResourceTypeDefinition;
import org.drools.workbench.screens.guided.rule.type.GuidedRuleDSLRResourceTypeDefinition;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.project.datamodel.imports.Import;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class GuidedRuleEditorServiceImpl
extends KieService<GuidedEditorContent>
implements GuidedRuleEditorService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private GuidedRuleEditorServiceUtilities utilities;
    @Inject
    private GuidedRuleDRLResourceTypeDefinition drlResourceType;
    @Inject
    private GuidedRuleDSLRResourceTypeDefinition dslrResourceType;
    @Inject
    private GenericValidator genericValidator;
    @Inject
    private CommentedOptionFactory commentedOptionFactory;
    @Inject
    private SaveAndRenameServiceImpl<RuleModel, Metadata> saveAndRenameService;
    private SafeSessionInfo safeSessionInfo;
    private Collection<RuleModelIActionPersistenceExtension> persistenceExtensions = new ArrayList<RuleModelIActionPersistenceExtension>();

    public GuidedRuleEditorServiceImpl() {
    }

    @Inject
    public GuidedRuleEditorServiceImpl(SessionInfo sessionInfo, Instance<RuleModelIActionPersistenceExtension> persistenceExtensionInstance) {
        this.safeSessionInfo = new SafeSessionInfo(sessionInfo);
        persistenceExtensionInstance.forEach(this.persistenceExtensions::add);
    }

    @PostConstruct
    public void init() {
        this.saveAndRenameService.init((SupportsSaveAndRename)this);
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, RuleModel model, String comment) {
        try {
            Package pkg = this.moduleService.resolvePackage(context);
            String packageName = pkg == null ? null : pkg.getPackageName();
            model.setPackageName(packageName);
            model.getImports().addImport(new Import("java.lang.Number"));
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
            if (this.ioService.exists(nioPath)) {
                throw new FileAlreadyExistsException(nioPath.toString());
            }
            this.ioService.write(nioPath, this.toSource(newPath, model), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public RuleModel load(org.uberfire.backend.vfs.Path path) {
        try {
            String drl = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            List<String> globals = this.utilities.loadGlobalsForPackage(path);
            PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
            RuleModel ruleModel = null;
            if (this.dslrResourceType.accept(path)) {
                String[] dsls = this.utilities.loadDslsForPackage(path);
                ruleModel = RuleModelDRLPersistenceImpl.getInstance().unmarshalUsingDSL(drl, globals, oracle, this.persistenceExtensions, dsls);
            } else {
                ruleModel = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, globals, oracle, this.persistenceExtensions);
            }
            return ruleModel;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public GuidedEditorContent loadContent(org.uberfire.backend.vfs.Path path) {
        return (GuidedEditorContent)super.loadContent(path);
    }

    protected GuidedEditorContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        RuleModel model = this.load(path);
        PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
        PackageDataModelOracleBaselinePayload dataModel = new PackageDataModelOracleBaselinePayload();
        GuidedRuleModelVisitor visitor = new GuidedRuleModelVisitor(model);
        Set<String> consumedFQCNs = visitor.getConsumedModelClasses();
        consumedFQCNs.addAll(oracle.getPackageGlobals().values());
        consumedFQCNs.addAll(oracle.getModuleCollectionTypes().entrySet().stream().filter(entry -> (Boolean)entry.getValue()).map(entry -> (String)entry.getKey()).collect(Collectors.toSet()));
        DataModelOracleUtilities.populateDataModel((PackageDataModelOracle)oracle, (PackageDataModelOracleBaselinePayload)dataModel, consumedFQCNs);
        this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, (SessionInfo)this.safeSessionInfo));
        return new GuidedEditorContent(model, overview, dataModel);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, RuleModel model, Metadata metadata, String comment) {
        try {
            Package pkg = this.moduleService.resolvePackage(resource);
            String packageName = pkg == null ? null : pkg.getPackageName();
            model.setPackageName(packageName);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), this.toSourceUnexpanded(resource, model), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, org.uberfire.backend.vfs.Path targetDirectory, String comment) {
        try {
            return this.copyService.copy(path, newName, targetDirectory, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public String toSource(org.uberfire.backend.vfs.Path path, RuleModel model) {
        try {
            return this.toSourceExpanded(path, model);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, RuleModel content) {
        try {
            String source = this.toSourceUnexpanded(path, content);
            return this.genericValidator.validate(path, source);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private String toSourceExpanded(org.uberfire.backend.vfs.Path path, RuleModel model) {
        return this.sourceServices.getServiceFor(Paths.convert((org.uberfire.backend.vfs.Path)path)).getSource(Paths.convert((org.uberfire.backend.vfs.Path)path), (Object)model);
    }

    private String toSourceUnexpanded(org.uberfire.backend.vfs.Path path, RuleModel content) {
        RuleModelWrapper model = new RuleModelWrapper(content, this.dslrResourceType.accept(path));
        String source = RuleModelDRLPersistenceImpl.getInstance().marshal((RuleModel)model);
        return source;
    }

    public org.uberfire.backend.vfs.Path saveAndRename(org.uberfire.backend.vfs.Path path, String newFileName, Metadata metadata, RuleModel content, String comment) {
        return this.saveAndRenameService.saveAndRename(path, newFileName, (Object)metadata, (Object)content, comment);
    }
}

