/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import org.fest.assertions.api.AbstractComparableAssert;
import org.fest.assertions.core.FloatingPointNumberAssert;
import org.fest.assertions.data.Offset;
import org.fest.assertions.internal.ComparatorBasedComparisonStrategy;
import org.fest.assertions.internal.Doubles;
import org.fest.util.VisibleForTesting;

public class DoubleAssert
extends AbstractComparableAssert<DoubleAssert, Double>
implements FloatingPointNumberAssert<Double> {
    @VisibleForTesting
    Doubles doubles = Doubles.instance();

    protected DoubleAssert(Double actual) {
        super(actual, DoubleAssert.class);
    }

    public DoubleAssert isNaN() {
        this.doubles.assertIsNaN(this.info, (Comparable)this.actual);
        return this;
    }

    public DoubleAssert isNotNaN() {
        this.doubles.assertIsNotNaN(this.info, (Comparable)this.actual);
        return this;
    }

    public DoubleAssert isZero() {
        this.doubles.assertIsZero(this.info, (Comparable)this.actual);
        return this;
    }

    public DoubleAssert isNotZero() {
        this.doubles.assertIsNotZero(this.info, (Comparable)this.actual);
        return this;
    }

    public DoubleAssert isPositive() {
        this.doubles.assertIsPositive(this.info, (Comparable)this.actual);
        return this;
    }

    public DoubleAssert isNegative() {
        this.doubles.assertIsNegative(this.info, (Comparable)this.actual);
        return this;
    }

    public DoubleAssert isNotNegative() {
        this.doubles.assertIsNotNegative(this.info, (Comparable)this.actual);
        return this;
    }

    public DoubleAssert isNotPositive() {
        this.doubles.assertIsNotPositive(this.info, (Comparable)this.actual);
        return this;
    }

    @Override
    public DoubleAssert isEqualTo(double expected) {
        this.doubles.assertEqual(this.info, this.actual, expected);
        return this;
    }

    public DoubleAssert isEqualTo(Double expected, Offset<Double> offset) {
        this.doubles.assertEqual(this.info, (Double)this.actual, expected, offset);
        return this;
    }

    public DoubleAssert isEqualTo(double expected, Offset<Double> offset) {
        this.doubles.assertEqual(this.info, (Double)this.actual, expected, offset);
        return this;
    }

    @Override
    public DoubleAssert isNotEqualTo(double other) {
        this.doubles.assertNotEqual(this.info, this.actual, other);
        return this;
    }

    @Override
    public DoubleAssert isLessThan(double other) {
        this.doubles.assertLessThan(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public DoubleAssert isLessThanOrEqualTo(double other) {
        this.doubles.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public DoubleAssert isGreaterThan(double other) {
        this.doubles.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public DoubleAssert isGreaterThanOrEqualTo(double other) {
        this.doubles.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public DoubleAssert usingComparator(Comparator<? super Double> customComparator) {
        super.usingComparator(customComparator);
        this.doubles = new Doubles(new ComparatorBasedComparisonStrategy(customComparator));
        return (DoubleAssert)this.myself;
    }

    @Override
    public DoubleAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.doubles = Doubles.instance();
        return (DoubleAssert)this.myself;
    }
}

