/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.error;

import org.fest.assertions.description.Description;
import org.fest.assertions.error.DescriptionFormatter;
import org.fest.assertions.internal.ComparatorBasedComparisonStrategy;
import org.fest.assertions.internal.StandardComparisonStrategy;
import org.fest.util.Preconditions;
import org.fest.util.ToString;
import org.fest.util.VisibleForTesting;

public class MessageFormatter {
    private static final MessageFormatter INSTANCE = new MessageFormatter();
    @VisibleForTesting
    DescriptionFormatter descriptionFormatter = DescriptionFormatter.instance();

    public static MessageFormatter instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    MessageFormatter() {
    }

    public String format(Description d, String format, Object ... args) {
        Preconditions.checkNotNull((Object)format);
        Preconditions.checkNotNull((Object)args);
        return this.descriptionFormatter.format(d) + String.format(format, this.format(args));
    }

    private Object[] format(Object[] args) {
        int argCount = args.length;
        Object[] formatted = new String[argCount];
        for (int i = 0; i < argCount; ++i) {
            formatted[i] = this.asText(args[i]);
        }
        return formatted;
    }

    private String asText(Object o) {
        if (o instanceof ComparatorBasedComparisonStrategy) {
            return " according to " + o + " comparator";
        }
        if (o instanceof StandardComparisonStrategy) {
            return "";
        }
        return ToString.toStringOf((Object)o);
    }
}

