/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import java.lang.reflect.Array;
import java.util.HashSet;
import org.fest.assertions.internal.ComparisonStrategy;
import org.fest.util.Iterables;

public abstract class AbstractComparisonStrategy
implements ComparisonStrategy {
    @Override
    public Iterable<?> duplicatesFrom(Iterable<?> iterable) {
        HashSet duplicates = new HashSet();
        if (Iterables.isNullOrEmpty(iterable)) {
            return duplicates;
        }
        HashSet noDuplicates = new HashSet();
        for (Object element : iterable) {
            if (this.iterableContains(noDuplicates, element)) {
                duplicates.add(element);
                continue;
            }
            noDuplicates.add(element);
        }
        return duplicates;
    }

    @Override
    public boolean arrayContains(Object array, Object value) {
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object element = Array.get(array, i);
            if (!this.areEqual(element, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLessThan(Object actual, Object other) {
        if (this.areEqual(actual, other)) {
            return false;
        }
        return !this.isGreaterThan(actual, other);
    }

    @Override
    public boolean isLessThanOrEqualTo(Object actual, Object other) {
        if (this.areEqual(actual, other)) {
            return true;
        }
        return this.isLessThan(actual, other);
    }

    @Override
    public boolean isGreaterThanOrEqualTo(Object actual, Object other) {
        if (this.areEqual(actual, other)) {
            return true;
        }
        return this.isGreaterThan(actual, other);
    }
}

