/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import java.util.Comparator;
import java.util.Date;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.error.ShouldBeAfter;
import org.fest.assertions.error.ShouldBeAfterOrEqualsTo;
import org.fest.assertions.error.ShouldBeBefore;
import org.fest.assertions.error.ShouldBeBeforeOrEqualsTo;
import org.fest.assertions.error.ShouldBeBetween;
import org.fest.assertions.error.ShouldBeCloseTo;
import org.fest.assertions.error.ShouldBeInSameDay;
import org.fest.assertions.error.ShouldBeInSameHour;
import org.fest.assertions.error.ShouldBeInSameMinute;
import org.fest.assertions.error.ShouldBeInSameMonth;
import org.fest.assertions.error.ShouldBeInSameSecond;
import org.fest.assertions.error.ShouldBeInSameYear;
import org.fest.assertions.error.ShouldBeInTheFuture;
import org.fest.assertions.error.ShouldBeInThePast;
import org.fest.assertions.error.ShouldBeToday;
import org.fest.assertions.error.ShouldBeWithin;
import org.fest.assertions.error.ShouldHaveTime;
import org.fest.assertions.error.ShouldNotBeBetween;
import org.fest.assertions.internal.ComparatorBasedComparisonStrategy;
import org.fest.assertions.internal.ComparisonStrategy;
import org.fest.assertions.internal.Failures;
import org.fest.assertions.internal.Objects;
import org.fest.assertions.internal.StandardComparisonStrategy;
import org.fest.util.VisibleForTesting;

public class Dates {
    private static final Dates INSTANCE = new Dates();
    @VisibleForTesting
    Failures failures = Failures.instance();
    private ComparisonStrategy comparisonStrategy;

    public static Dates instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Dates() {
        this(StandardComparisonStrategy.instance());
    }

    public Dates(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
        }
        return null;
    }

    public void assertIsBefore(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (this.isBefore(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeBefore.shouldBeBefore(actual, other, this.comparisonStrategy));
    }

    public void assertIsBeforeOrEqualsTo(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (this.isBeforeOrEqualTo(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeBeforeOrEqualsTo.shouldBeBeforeOrEqualsTo(actual, other, this.comparisonStrategy));
    }

    public void assertIsAfter(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (this.isAfter(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeAfter.shouldBeAfter(actual, other, this.comparisonStrategy));
    }

    public void assertIsAfterOrEqualsTo(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (this.isAfterOrEqualTo(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeAfterOrEqualsTo.shouldBeAfterOrEqualsTo(actual, other, this.comparisonStrategy));
    }

    public void assertIsBetween(AssertionInfo info, Date actual, Date start, Date end, boolean inclusiveStart, boolean inclusiveEnd) {
        boolean checkUpperBoundaryPeriod;
        this.assertNotNull(info, actual);
        Dates.startDateParameterIsNotNull(start);
        Dates.endDateParameterIsNotNull(end);
        boolean checkLowerBoundaryPeriod = inclusiveStart ? this.isAfterOrEqualTo(actual, start) : this.isAfter(actual, start);
        boolean bl = checkUpperBoundaryPeriod = inclusiveEnd ? this.isBeforeOrEqualTo(actual, end) : this.isBefore(actual, end);
        if (checkLowerBoundaryPeriod && checkUpperBoundaryPeriod) {
            return;
        }
        throw this.failures.failure(info, ShouldBeBetween.shouldBeBetween(actual, start, end, inclusiveStart, inclusiveEnd, this.comparisonStrategy));
    }

    public void assertIsNotBetween(AssertionInfo info, Date actual, Date start, Date end, boolean inclusiveStart, boolean inclusiveEnd) {
        boolean isBetweenGivenPeriod;
        this.assertNotNull(info, actual);
        Dates.startDateParameterIsNotNull(start);
        Dates.endDateParameterIsNotNull(end);
        boolean checkLowerBoundaryPeriod = inclusiveStart ? this.isAfterOrEqualTo(actual, start) : this.isAfter(actual, start);
        boolean checkUpperBoundaryPeriod = inclusiveEnd ? this.isBeforeOrEqualTo(actual, end) : this.isBefore(actual, end);
        boolean bl = isBetweenGivenPeriod = checkLowerBoundaryPeriod && checkUpperBoundaryPeriod;
        if (!isBetweenGivenPeriod) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeBetween.shouldNotBeBetween(actual, start, end, inclusiveStart, inclusiveEnd, this.comparisonStrategy));
    }

    public void assertIsInThePast(AssertionInfo info, Date actual) {
        this.assertNotNull(info, actual);
        if (this.isBefore(actual, org.fest.util.Dates.today())) {
            return;
        }
        throw this.failures.failure(info, ShouldBeInThePast.shouldBeInThePast(actual, this.comparisonStrategy));
    }

    public void assertIsToday(AssertionInfo info, Date actual) {
        this.assertNotNull(info, actual);
        Date todayWithoutTime = org.fest.util.Dates.truncateTime((Date)org.fest.util.Dates.today());
        Date actualWithoutTime = org.fest.util.Dates.truncateTime((Date)actual);
        if (this.areEqual(actualWithoutTime, todayWithoutTime)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeToday.shouldBeToday(actual, this.comparisonStrategy));
    }

    public void assertIsInTheFuture(AssertionInfo info, Date actual) {
        this.assertNotNull(info, actual);
        if (this.isAfter(actual, org.fest.util.Dates.today())) {
            return;
        }
        throw this.failures.failure(info, ShouldBeInTheFuture.shouldBeInTheFuture(actual, this.comparisonStrategy));
    }

    public void assertIsBeforeYear(AssertionInfo info, Date actual, int year) {
        this.assertNotNull(info, actual);
        if (org.fest.util.Dates.yearOf((Date)actual) < year) {
            return;
        }
        throw this.failures.failure(info, ShouldBeBefore.shouldBeBefore(actual, year));
    }

    public void assertIsAfterYear(AssertionInfo info, Date actual, int year) {
        this.assertNotNull(info, actual);
        if (org.fest.util.Dates.yearOf((Date)actual) > year) {
            return;
        }
        throw this.failures.failure(info, ShouldBeAfter.shouldBeAfter(actual, year));
    }

    public void assertIsWithinYear(AssertionInfo info, Date actual, int year) {
        this.assertNotNull(info, actual);
        if (org.fest.util.Dates.yearOf((Date)actual) == year) {
            return;
        }
        throw this.failures.failure(info, ShouldBeWithin.shouldBeWithin(actual, "year", year));
    }

    public void assertIsWithinMonth(AssertionInfo info, Date actual, int month) {
        this.assertNotNull(info, actual);
        if (org.fest.util.Dates.monthOf((Date)actual) == month) {
            return;
        }
        throw this.failures.failure(info, ShouldBeWithin.shouldBeWithin(actual, "month", month));
    }

    public void assertIsWithinDayOfMonth(AssertionInfo info, Date actual, int dayOfMonth) {
        this.assertNotNull(info, actual);
        if (org.fest.util.Dates.dayOfMonthOf((Date)actual) == dayOfMonth) {
            return;
        }
        throw this.failures.failure(info, ShouldBeWithin.shouldBeWithin(actual, "day of month", dayOfMonth));
    }

    public void assertIsWithinDayOfWeek(AssertionInfo info, Date actual, int dayOfWeek) {
        this.assertNotNull(info, actual);
        if (org.fest.util.Dates.dayOfWeekOf((Date)actual) == dayOfWeek) {
            return;
        }
        throw this.failures.failure(info, ShouldBeWithin.shouldBeWithin(actual, "day of week", dayOfWeek));
    }

    public void assertIsWithinHourOfDay(AssertionInfo info, Date actual, int hourOfDay) {
        this.assertNotNull(info, actual);
        if (org.fest.util.Dates.hourOfDay((Date)actual) == hourOfDay) {
            return;
        }
        throw this.failures.failure(info, ShouldBeWithin.shouldBeWithin(actual, "hour", hourOfDay));
    }

    public void assertIsWithinMinute(AssertionInfo info, Date actual, int minute) {
        this.assertNotNull(info, actual);
        if (org.fest.util.Dates.minuteOf((Date)actual) == minute) {
            return;
        }
        throw this.failures.failure(info, ShouldBeWithin.shouldBeWithin(actual, "minute", minute));
    }

    public void assertIsWithinSecond(AssertionInfo info, Date actual, int second) {
        this.assertNotNull(info, actual);
        if (org.fest.util.Dates.secondOf((Date)actual) == second) {
            return;
        }
        throw this.failures.failure(info, ShouldBeWithin.shouldBeWithin(actual, "second", second));
    }

    public void assertIsWithinMillisecond(AssertionInfo info, Date actual, int millisecond) {
        this.assertNotNull(info, actual);
        if (org.fest.util.Dates.millisecondOf((Date)actual) == millisecond) {
            return;
        }
        throw this.failures.failure(info, ShouldBeWithin.shouldBeWithin(actual, "millisecond", millisecond));
    }

    public void assertIsInSameYearAs(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (Dates.areInSameYear(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeInSameYear.shouldBeInSameYear(actual, other));
    }

    private static boolean areInSameYear(Date actual, Date other) {
        return org.fest.util.Dates.yearOf((Date)actual) == org.fest.util.Dates.yearOf((Date)other);
    }

    public void assertIsInSameMonthAs(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (Dates.areInSameMonth(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeInSameMonth.shouldBeInSameMonth(actual, other));
    }

    private static boolean areInSameMonth(Date actual, Date other) {
        return Dates.areInSameYear(actual, other) && org.fest.util.Dates.monthOf((Date)actual) == org.fest.util.Dates.monthOf((Date)other);
    }

    public void assertIsInSameDayAs(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (Dates.areInSameDayOfMonth(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeInSameDay.shouldBeInSameDay(actual, other));
    }

    private static boolean areInSameDayOfMonth(Date actual, Date other) {
        return Dates.areInSameMonth(actual, other) && org.fest.util.Dates.dayOfMonthOf((Date)actual) == org.fest.util.Dates.dayOfMonthOf((Date)other);
    }

    public void assertIsInSameHourAs(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (Dates.areInSameHour(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeInSameHour.shouldBeInSameHour(actual, other));
    }

    private static boolean areInSameHour(Date actual, Date other) {
        return Dates.areInSameDayOfMonth(actual, other) && org.fest.util.Dates.hourOfDay((Date)actual) == org.fest.util.Dates.hourOfDay((Date)other);
    }

    public void assertIsInSameMinuteAs(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (Dates.areInSameMinute(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeInSameMinute.shouldBeInSameMinute(actual, other));
    }

    private static boolean areInSameMinute(Date actual, Date other) {
        return Dates.areInSameHour(actual, other) && org.fest.util.Dates.minuteOf((Date)actual) == org.fest.util.Dates.minuteOf((Date)other);
    }

    public void assertIsInSameSecondAs(AssertionInfo info, Date actual, Date other) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        if (Dates.areInSameSecond(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeInSameSecond.shouldBeInSameSecond(actual, other));
    }

    private static boolean areInSameSecond(Date actual, Date other) {
        return Dates.areInSameMinute(actual, other) && org.fest.util.Dates.secondOf((Date)actual) == org.fest.util.Dates.secondOf((Date)other);
    }

    public void assertIsCloseTo(AssertionInfo info, Date actual, Date other, long deltaInMilliseconds) {
        this.assertNotNull(info, actual);
        Dates.dateParameterIsNotNull(other);
        long difference = Math.abs(actual.getTime() - other.getTime());
        if (difference <= deltaInMilliseconds) {
            return;
        }
        throw this.failures.failure(info, ShouldBeCloseTo.shouldBeCloseTo(actual, other, deltaInMilliseconds, difference));
    }

    public void assertHasTime(AssertionInfo info, Date actual, long timestamp) {
        this.assertNotNull(info, actual);
        if (actual.getTime() == timestamp) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveTime.shouldHaveTime(actual, timestamp));
    }

    private static void dateParameterIsNotNull(Date date) {
        if (date == null) {
            throw new NullPointerException("The date to compare actual with should not be null");
        }
    }

    private static void startDateParameterIsNotNull(Date start) {
        if (start == null) {
            throw new NullPointerException("The start date of period to compare actual with should not be null");
        }
    }

    private static void endDateParameterIsNotNull(Date end) {
        if (end == null) {
            throw new NullPointerException("The end date of period to compare actual with should not be null");
        }
    }

    private void assertNotNull(AssertionInfo info, Date actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    private boolean isBeforeOrEqualTo(Date actual, Date other) {
        return this.comparisonStrategy.isLessThanOrEqualTo(actual, other);
    }

    private boolean areEqual(Date actual, Date other) {
        return this.comparisonStrategy.areEqual(other, actual);
    }

    private boolean isAfterOrEqualTo(Date actual, Date other) {
        return this.comparisonStrategy.isGreaterThanOrEqualTo(actual, other);
    }

    private boolean isBefore(Date actual, Date other) {
        return this.comparisonStrategy.isLessThan(actual, other);
    }

    private boolean isAfter(Date actual, Date other) {
        return this.comparisonStrategy.isGreaterThan(actual, other);
    }
}

