/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.core.Condition;
import org.fest.assertions.core.ObjectEnumerableAssert;
import org.fest.assertions.internal.Iterables;
import org.fest.util.ComparatorBasedComparisonStrategy;
import org.fest.util.ComparisonStrategy;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIterableAssert<S, A extends Iterable<?>>
extends AbstractAssert<S, A>
implements ObjectEnumerableAssert<S> {
    @VisibleForTesting
    Iterables iterables = Iterables.instance();

    protected AbstractIterableAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    @Override
    public final void isNullOrEmpty() {
        this.iterables.assertNullOrEmpty(this.info, (Iterable)this.actual);
    }

    @Override
    public final void isEmpty() {
        this.iterables.assertEmpty(this.info, (Iterable)this.actual);
    }

    @Override
    public final S isNotEmpty() {
        this.iterables.assertNotEmpty(this.info, (Iterable)this.actual);
        return (S)this.myself;
    }

    @Override
    public final S hasSize(int expected) {
        this.iterables.assertHasSize(this.info, (Iterable)this.actual, expected);
        return (S)this.myself;
    }

    @Override
    public final S contains(Object ... values) {
        this.iterables.assertContains(this.info, (Iterable)this.actual, values);
        return (S)this.myself;
    }

    @Override
    public final S containsOnly(Object ... values) {
        this.iterables.assertContainsOnly(this.info, (Iterable)this.actual, values);
        return (S)this.myself;
    }

    public final S isSubsetOf(Iterable<?> values) {
        this.iterables.assertIsSubsetOf(this.info, (Iterable)this.actual, values);
        return (S)this.myself;
    }

    @Override
    public final S containsSequence(Object ... sequence) {
        this.iterables.assertContainsSequence(this.info, (Iterable)this.actual, sequence);
        return (S)this.myself;
    }

    @Override
    public final S doesNotContain(Object ... values) {
        this.iterables.assertDoesNotContain(this.info, (Iterable)this.actual, values);
        return (S)this.myself;
    }

    @Override
    public final S doesNotHaveDuplicates() {
        this.iterables.assertDoesNotHaveDuplicates(this.info, (Iterable)this.actual);
        return (S)this.myself;
    }

    @Override
    public final S startsWith(Object ... sequence) {
        this.iterables.assertStartsWith(this.info, (Iterable)this.actual, sequence);
        return (S)this.myself;
    }

    @Override
    public final S endsWith(Object ... sequence) {
        this.iterables.assertEndsWith(this.info, (Iterable)this.actual, sequence);
        return (S)this.myself;
    }

    @Override
    public S containsNull() {
        this.iterables.assertContainsNull(this.info, (Iterable)this.actual);
        return (S)this.myself;
    }

    @Override
    public S doesNotContainNull() {
        this.iterables.assertDoesNotContainNull(this.info, (Iterable)this.actual);
        return (S)this.myself;
    }

    @Override
    public <E> S are(Condition<E> condition) {
        this.iterables.assertAre(this.info, (Iterable)this.actual, condition);
        return (S)this.myself;
    }

    @Override
    public <E> S areNot(Condition<E> condition) {
        this.iterables.assertAreNot(this.info, (Iterable)this.actual, condition);
        return (S)this.myself;
    }

    @Override
    public <E> S have(Condition<E> condition) {
        this.iterables.assertHave(this.info, (Iterable)this.actual, condition);
        return (S)this.myself;
    }

    @Override
    public <E> S doNotHave(Condition<E> condition) {
        this.iterables.assertDoNotHave(this.info, (Iterable)this.actual, condition);
        return (S)this.myself;
    }

    @Override
    public <E> S areAtLeast(int times, Condition<E> condition) {
        this.iterables.assertAreAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (S)this.myself;
    }

    @Override
    public <E> S areNotAtLeast(int times, Condition<E> condition) {
        this.iterables.assertAreNotAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (S)this.myself;
    }

    @Override
    public <E> S areAtMost(int times, Condition<E> condition) {
        this.iterables.assertAreAtMost(this.info, (Iterable)this.actual, times, condition);
        return (S)this.myself;
    }

    @Override
    public <E> S areNotAtMost(int times, Condition<E> condition) {
        this.iterables.assertAreNotAtMost(this.info, (Iterable)this.actual, times, condition);
        return (S)this.myself;
    }

    @Override
    public <E> S areExactly(int times, Condition<E> condition) {
        this.iterables.assertAreExactly(this.info, (Iterable)this.actual, times, condition);
        return (S)this.myself;
    }

    @Override
    public <E> S areNotExactly(int times, Condition<E> condition) {
        this.iterables.assertAreNotExactly(this.info, (Iterable)this.actual, times, condition);
        return (S)this.myself;
    }

    @Override
    public <E> S haveAtLeast(int times, Condition<E> condition) {
        this.iterables.assertHaveAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (S)this.myself;
    }

    @Override
    public <E> S doNotHaveAtLeast(int times, Condition<E> condition) {
        this.iterables.assertDoNotHaveAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (S)this.myself;
    }

    @Override
    public <E> S haveAtMost(int times, Condition<E> condition) {
        this.iterables.assertHaveAtMost(this.info, (Iterable)this.actual, times, condition);
        return (S)this.myself;
    }

    @Override
    public <E> S doNotHaveAtMost(int times, Condition<E> condition) {
        this.iterables.assertDoNotHaveAtMost(this.info, (Iterable)this.actual, times, condition);
        return (S)this.myself;
    }

    @Override
    public <E> S haveExactly(int times, Condition<E> condition) {
        this.iterables.assertHaveExactly(this.info, (Iterable)this.actual, times, condition);
        return (S)this.myself;
    }

    @Override
    public <E> S doNotHaveExactly(int times, Condition<E> condition) {
        this.iterables.assertDoNotHaveExactly(this.info, (Iterable)this.actual, times, condition);
        return (S)this.myself;
    }

    @Override
    public S usingComparator(Comparator<?> customComparator) {
        super.usingComparator(customComparator);
        this.iterables = new Iterables((ComparisonStrategy)new ComparatorBasedComparisonStrategy(customComparator));
        return (S)this.myself;
    }

    @Override
    public S usingDefaultComparator() {
        super.usingDefaultComparator();
        this.iterables = Iterables.instance();
        return (S)this.myself;
    }
}

