/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.io.File;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.internal.Files;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAssert
extends AbstractAssert<FileAssert, File> {
    @VisibleForTesting
    Files files = Files.instance();

    protected FileAssert(File actual) {
        super(actual, FileAssert.class);
    }

    public FileAssert exists() {
        this.files.assertExists(this.info, (File)this.actual);
        return this;
    }

    public FileAssert doesNotExist() {
        this.files.assertDoesNotExist(this.info, (File)this.actual);
        return this;
    }

    public FileAssert isFile() {
        this.files.assertIsFile(this.info, (File)this.actual);
        return this;
    }

    public FileAssert isDirectory() {
        this.files.assertIsDirectory(this.info, (File)this.actual);
        return this;
    }

    public FileAssert isAbsolute() {
        this.files.assertIsAbsolute(this.info, (File)this.actual);
        return this;
    }

    public FileAssert isRelative() {
        this.files.assertIsRelative(this.info, (File)this.actual);
        return this;
    }

    public FileAssert hasContentEqualTo(File expected) {
        this.files.assertEqualContent(this.info, (File)this.actual, expected);
        return this;
    }
}

