/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.core.ArraySortedAssert;
import org.fest.assertions.core.EnumerableAssert;
import org.fest.assertions.data.Index;
import org.fest.assertions.internal.FloatArrays;
import org.fest.util.ComparatorBasedComparisonStrategy;
import org.fest.util.ComparisonStrategy;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatArrayAssert
extends AbstractAssert<FloatArrayAssert, float[]>
implements EnumerableAssert<FloatArrayAssert>,
ArraySortedAssert<FloatArrayAssert, Float> {
    @VisibleForTesting
    FloatArrays arrays = FloatArrays.instance();

    protected FloatArrayAssert(float[] actual) {
        super(actual, FloatArrayAssert.class);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (float[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (float[])this.actual);
    }

    @Override
    public FloatArrayAssert isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (float[])this.actual);
        return this;
    }

    @Override
    public FloatArrayAssert hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (float[])this.actual, expected);
        return this;
    }

    public FloatArrayAssert contains(float ... values) {
        this.arrays.assertContains(this.info, (float[])this.actual, values);
        return this;
    }

    public FloatArrayAssert containsOnly(float ... values) {
        this.arrays.assertContainsOnly(this.info, (float[])this.actual, values);
        return this;
    }

    public FloatArrayAssert containsSequence(float ... sequence) {
        this.arrays.assertContainsSequence(this.info, (float[])this.actual, sequence);
        return this;
    }

    public FloatArrayAssert contains(float value, Index index) {
        this.arrays.assertContains(this.info, (float[])this.actual, value, index);
        return this;
    }

    public FloatArrayAssert doesNotContain(float ... values) {
        this.arrays.assertDoesNotContain(this.info, (float[])this.actual, values);
        return this;
    }

    public FloatArrayAssert doesNotContain(float value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (float[])this.actual, value, index);
        return this;
    }

    public FloatArrayAssert doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (float[])this.actual);
        return this;
    }

    public FloatArrayAssert startsWith(float ... sequence) {
        this.arrays.assertStartsWith(this.info, (float[])this.actual, sequence);
        return this;
    }

    public FloatArrayAssert endsWith(float ... sequence) {
        this.arrays.assertEndsWith(this.info, (float[])this.actual, sequence);
        return this;
    }

    @Override
    public FloatArrayAssert isSorted() {
        this.arrays.assertIsSorted(this.info, (float[])this.actual);
        return this;
    }

    @Override
    public FloatArrayAssert isSortedAccordingTo(Comparator<? extends Float> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (float[])this.actual, comparator);
        return this;
    }

    @Override
    public FloatArrayAssert usingComparator(Comparator<?> customComparator) {
        super.usingComparator(customComparator);
        this.arrays = new FloatArrays((ComparisonStrategy)new ComparatorBasedComparisonStrategy(customComparator));
        return (FloatArrayAssert)this.myself;
    }

    @Override
    public FloatArrayAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.arrays = FloatArrays.instance();
        return (FloatArrayAssert)this.myself;
    }
}

