/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.Comparator;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.data.Offset;
import org.fest.assertions.internal.Images;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageAssert
extends AbstractAssert<ImageAssert, BufferedImage> {
    @VisibleForTesting
    Images images = Images.instance();

    protected ImageAssert(BufferedImage actual) {
        super(actual, ImageAssert.class);
    }

    @Override
    public ImageAssert isEqualTo(BufferedImage expected) {
        this.images.assertEqual(this.info, (BufferedImage)this.actual, expected);
        return this;
    }

    public ImageAssert isEqualTo(BufferedImage expected, Offset<Integer> offset) {
        this.images.assertEqual(this.info, (BufferedImage)this.actual, expected, offset);
        return this;
    }

    @Override
    public ImageAssert isNotEqualTo(BufferedImage other) {
        this.images.assertNotEqual(this.info, (BufferedImage)this.actual, other);
        return this;
    }

    public ImageAssert hasSize(Dimension expected) {
        this.images.assertHasSize(this.info, (BufferedImage)this.actual, expected);
        return this;
    }

    @Override
    public ImageAssert usingComparator(Comparator<?> customComparator) {
        throw new UnsupportedOperationException("custom Comparator is not supported for image comparison");
    }

    @Override
    public ImageAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.images = Images.instance();
        return (ImageAssert)this.myself;
    }
}

