/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import java.util.List;
import org.fest.assertions.api.AbstractIterableAssert;
import org.fest.assertions.core.IndexedObjectEnumerableAssert;
import org.fest.assertions.data.Index;
import org.fest.assertions.internal.Lists;
import org.fest.util.ComparatorBasedComparisonStrategy;
import org.fest.util.ComparisonStrategy;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListAssert
extends AbstractIterableAssert<ListAssert, List<?>>
implements IndexedObjectEnumerableAssert {
    @VisibleForTesting
    Lists lists = Lists.instance();

    protected ListAssert(List<?> actual) {
        super(actual, ListAssert.class);
    }

    @Override
    public ListAssert contains(Object value, Index index) {
        this.lists.assertContains(this.info, (List)this.actual, value, index);
        return this;
    }

    @Override
    public ListAssert doesNotContain(Object value, Index index) {
        this.lists.assertDoesNotContain(this.info, (List)this.actual, value, index);
        return this;
    }

    public ListAssert isSorted() {
        this.lists.assertIsSorted(this.info, (List)this.actual);
        return this;
    }

    public ListAssert isSortedAccordingTo(Comparator<? extends Object> comparator) {
        this.lists.assertIsSortedAccordingToComparator(this.info, (List)this.actual, comparator);
        return this;
    }

    @Override
    public ListAssert usingComparator(Comparator<?> customComparator) {
        super.usingComparator(customComparator);
        this.lists = new Lists((ComparisonStrategy)new ComparatorBasedComparisonStrategy(customComparator));
        return (ListAssert)this.myself;
    }

    @Override
    public ListAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.lists = Lists.instance();
        return (ListAssert)this.myself;
    }
}

