/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import org.fest.assertions.api.AbstractComparableAssert;
import org.fest.assertions.core.NumberAssert;
import org.fest.assertions.internal.Longs;
import org.fest.util.ComparatorBasedComparisonStrategy;
import org.fest.util.ComparisonStrategy;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongAssert
extends AbstractComparableAssert<LongAssert, Long>
implements NumberAssert<Long> {
    @VisibleForTesting
    Longs longs = Longs.instance();

    protected LongAssert(Long actual) {
        super(actual, LongAssert.class);
    }

    @Override
    public LongAssert isEqualTo(long expected) {
        this.longs.assertEqual(this.info, this.actual, expected);
        return this;
    }

    @Override
    public LongAssert isNotEqualTo(long other) {
        this.longs.assertNotEqual(this.info, this.actual, other);
        return this;
    }

    public LongAssert isZero() {
        this.longs.assertIsZero(this.info, (Comparable)this.actual);
        return this;
    }

    public LongAssert isNotZero() {
        this.longs.assertIsNotZero(this.info, (Comparable)this.actual);
        return this;
    }

    public LongAssert isPositive() {
        this.longs.assertIsPositive(this.info, (Comparable)this.actual);
        return this;
    }

    public LongAssert isNegative() {
        this.longs.assertIsNegative(this.info, (Comparable)this.actual);
        return this;
    }

    @Override
    public LongAssert isLessThan(long other) {
        this.longs.assertLessThan(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public LongAssert isLessThanOrEqualTo(long other) {
        this.longs.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public LongAssert isGreaterThan(long other) {
        this.longs.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public LongAssert isGreaterThanOrEqualTo(long other) {
        this.longs.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public LongAssert usingComparator(Comparator<?> customComparator) {
        super.usingComparator(customComparator);
        this.longs = new Longs((ComparisonStrategy)new ComparatorBasedComparisonStrategy(customComparator));
        return (LongAssert)this.myself;
    }

    @Override
    public LongAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.longs = Longs.instance();
        return (LongAssert)this.myself;
    }
}

