/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.core.ArraySortedAssert;
import org.fest.assertions.core.Condition;
import org.fest.assertions.core.IndexedObjectEnumerableAssert;
import org.fest.assertions.core.ObjectEnumerableAssert;
import org.fest.assertions.data.Index;
import org.fest.assertions.internal.ObjectArrays;
import org.fest.util.ComparatorBasedComparisonStrategy;
import org.fest.util.ComparisonStrategy;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArrayAssert
extends AbstractAssert<ObjectArrayAssert, Object[]>
implements ObjectEnumerableAssert<ObjectArrayAssert>,
IndexedObjectEnumerableAssert,
ArraySortedAssert<ObjectArrayAssert, Object> {
    @VisibleForTesting
    ObjectArrays arrays = ObjectArrays.instance();

    protected ObjectArrayAssert(Object[] actual) {
        super(actual, ObjectArrayAssert.class);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (Object[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (Object[])this.actual);
    }

    @Override
    public ObjectArrayAssert isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (Object[])this.actual);
        return this;
    }

    @Override
    public ObjectArrayAssert hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (Object[])this.actual, expected);
        return this;
    }

    @Override
    public ObjectArrayAssert contains(Object ... values) {
        this.arrays.assertContains(this.info, (Object[])this.actual, values);
        return this;
    }

    @Override
    public ObjectArrayAssert containsOnly(Object ... values) {
        this.arrays.assertContainsOnly(this.info, (Object[])this.actual, values);
        return this;
    }

    @Override
    public ObjectArrayAssert containsSequence(Object ... sequence) {
        this.arrays.assertContainsSequence(this.info, (Object[])this.actual, sequence);
        return this;
    }

    @Override
    public ObjectArrayAssert contains(Object value, Index index) {
        this.arrays.assertContains(this.info, (Object[])this.actual, value, index);
        return this;
    }

    @Override
    public ObjectArrayAssert doesNotContain(Object value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (Object[])this.actual, value, index);
        return this;
    }

    @Override
    public ObjectArrayAssert doesNotContain(Object ... values) {
        this.arrays.assertDoesNotContain(this.info, (Object[])this.actual, values);
        return this;
    }

    @Override
    public ObjectArrayAssert doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (Object[])this.actual);
        return this;
    }

    @Override
    public ObjectArrayAssert startsWith(Object ... sequence) {
        this.arrays.assertStartsWith(this.info, (Object[])this.actual, sequence);
        return this;
    }

    @Override
    public ObjectArrayAssert endsWith(Object ... sequence) {
        this.arrays.assertEndsWith(this.info, (Object[])this.actual, sequence);
        return this;
    }

    @Override
    public ObjectArrayAssert containsNull() {
        this.arrays.assertContainsNull(this.info, (Object[])this.actual);
        return this;
    }

    @Override
    public ObjectArrayAssert doesNotContainNull() {
        this.arrays.assertDoesNotContainNull(this.info, (Object[])this.actual);
        return this;
    }

    @Override
    public <E> ObjectArrayAssert are(Condition<E> condition) {
        this.arrays.assertAre(this.info, (Object[])this.actual, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public <E> ObjectArrayAssert areNot(Condition<E> condition) {
        this.arrays.assertAreNot(this.info, (Object[])this.actual, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public <E> ObjectArrayAssert have(Condition<E> condition) {
        this.arrays.assertHave(this.info, (Object[])this.actual, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public <E> ObjectArrayAssert doNotHave(Condition<E> condition) {
        this.arrays.assertDoNotHave(this.info, (Object[])this.actual, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public <E> ObjectArrayAssert areAtLeast(int times, Condition<E> condition) {
        this.arrays.assertAreAtLeast(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public <E> ObjectArrayAssert areNotAtLeast(int times, Condition<E> condition) {
        this.arrays.assertAreNotAtLeast(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public <E> ObjectArrayAssert areAtMost(int times, Condition<E> condition) {
        this.arrays.assertAreAtMost(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public <E> ObjectArrayAssert areNotAtMost(int times, Condition<E> condition) {
        this.arrays.assertAreNotAtMost(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public <E> ObjectArrayAssert areExactly(int times, Condition<E> condition) {
        this.arrays.assertAreExactly(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public <E> ObjectArrayAssert areNotExactly(int times, Condition<E> condition) {
        this.arrays.assertAreNotExactly(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public <E> ObjectArrayAssert haveAtLeast(int times, Condition<E> condition) {
        this.arrays.assertHaveAtLeast(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public <E> ObjectArrayAssert doNotHaveAtLeast(int times, Condition<E> condition) {
        this.arrays.assertDoNotHaveAtLeast(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public <E> ObjectArrayAssert haveAtMost(int times, Condition<E> condition) {
        this.arrays.assertHaveAtMost(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public <E> ObjectArrayAssert doNotHaveAtMost(int times, Condition<E> condition) {
        this.arrays.assertDoNotHaveAtMost(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public <E> ObjectArrayAssert haveExactly(int times, Condition<E> condition) {
        this.arrays.assertHaveExactly(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public <E> ObjectArrayAssert doNotHaveExactly(int times, Condition<E> condition) {
        this.arrays.assertDoNotHaveExactly(this.info, (Object[])this.actual, times, condition);
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert isSorted() {
        this.arrays.assertIsSorted(this.info, (Object[])this.actual);
        return this;
    }

    @Override
    public ObjectArrayAssert isSortedAccordingTo(Comparator<? extends Object> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (Object[])this.actual, comparator);
        return this;
    }

    @Override
    public ObjectArrayAssert usingComparator(Comparator<?> customComparator) {
        super.usingComparator(customComparator);
        this.arrays = new ObjectArrays((ComparisonStrategy)new ComparatorBasedComparisonStrategy(customComparator));
        return (ObjectArrayAssert)this.myself;
    }

    @Override
    public ObjectArrayAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.arrays = ObjectArrays.instance();
        return (ObjectArrayAssert)this.myself;
    }
}

