/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.condition;

import java.util.Collection;
import org.fest.assertions.condition.Join;
import org.fest.assertions.core.Condition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllOf<T>
extends Join<T> {
    public static <T> Condition<T> allOf(Condition<T> ... conditions) {
        return new AllOf<T>(conditions);
    }

    public static <T> Condition<T> allOf(Collection<Condition<T>> conditions) {
        return new AllOf<T>(conditions);
    }

    private AllOf(Condition<T> ... conditions) {
        super(conditions);
    }

    private AllOf(Collection<Condition<T>> conditions) {
        super(conditions);
    }

    @Override
    public boolean matches(T value) {
        for (Condition condition : this.conditions) {
            if (condition.matches(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return String.format("all of:<%s>", this.conditions);
    }
}

