/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.error;

import java.util.Date;
import org.fest.assertions.error.BasicErrorMessageFactory;
import org.fest.assertions.error.ErrorMessageFactory;
import org.fest.util.ComparisonStrategy;
import org.fest.util.Dates;
import org.fest.util.StandardComparisonStrategy;

public class ShouldBeBefore
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldBeBefore(Date actual, Date other, ComparisonStrategy comparisonStrategy) {
        return new ShouldBeBefore(actual, other, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldBeBefore(Date actual, Date other) {
        return new ShouldBeBefore(actual, other, (ComparisonStrategy)StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldBeBefore(Date actual, int year) {
        Date januaryTheFirstOfGivenYear = Dates.parse((String)(year + "-01-01"));
        return new ShouldBeBefore(actual, januaryTheFirstOfGivenYear, (ComparisonStrategy)StandardComparisonStrategy.instance());
    }

    private ShouldBeBefore(Date actual, Date other, ComparisonStrategy comparisonStrategy) {
        super("expected:<%s> to be strictly before :<%s>%s", actual, other, comparisonStrategy);
    }
}

