/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.groups;

import java.util.Collection;
import java.util.List;
import org.fest.assertions.internal.PropertySupport;
import org.fest.assertions.util.ArrayWrapperList;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties {
    @VisibleForTesting
    final String propertyName;
    @VisibleForTesting
    PropertySupport propertySupport = PropertySupport.instance();

    public static Properties extractProperty(String propertyName) {
        Properties.checkIsNotNullOrEmpty(propertyName);
        return new Properties(propertyName);
    }

    private static void checkIsNotNullOrEmpty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("The name of the property to read should not be null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("The name of the property to read should not be empty");
        }
    }

    @VisibleForTesting
    Properties(String propertyName) {
        this.propertyName = propertyName;
    }

    public List<?> from(Collection<?> c) {
        return this.propertySupport.propertyValues(this.propertyName, c);
    }

    public List<?> from(Object[] array) {
        return this.propertySupport.propertyValues(this.propertyName, ArrayWrapperList.wrap(array));
    }
}

