/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.data.Offset;
import org.fest.assertions.error.ShouldBeEqualWithinOffset;
import org.fest.assertions.internal.CommonValidations;
import org.fest.assertions.internal.RealNumbers;
import org.fest.util.ComparisonStrategy;
import org.fest.util.Objects;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Floats
extends RealNumbers<Float> {
    private static final Floats INSTANCE = new Floats();

    public static Floats instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Floats() {
    }

    public Floats(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    @Override
    protected Float zero() {
        return Float.valueOf(0.0f);
    }

    @Override
    protected Float NaN() {
        return Float.valueOf(Float.NaN);
    }

    @Override
    protected boolean isEqualTo(Float actual, Float expected, Offset<?> offset) {
        return Math.abs(expected.floatValue() - actual.floatValue()) <= ((Number)offset.value).floatValue();
    }

    public void assertEqual(AssertionInfo info, Float actual, Float expected, Offset<Float> offset) {
        Floats.assertNotNull(info, actual);
        CommonValidations.checkOffsetIsNotNull(offset);
        if (Objects.areEqual((Object)actual, (Object)expected)) {
            return;
        }
        if (expected != null && this.isEqualTo(actual, expected, offset)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqualWithinOffset.shouldBeEqual(actual, expected, offset));
    }
}

