/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.fest.assertions.internal.JavaBeanDescriptor;
import org.fest.util.Collections;
import org.fest.util.Introspection;
import org.fest.util.IntrospectionError;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertySupport {
    private static final String SEPARATOR = ".";
    private static final PropertySupport INSTANCE = new PropertySupport();
    @VisibleForTesting
    JavaBeanDescriptor javaBeanDescriptor = new JavaBeanDescriptor();

    public static PropertySupport instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    PropertySupport() {
    }

    public List<Object> propertyValues(String propertyName, Collection<?> target) {
        Collection cleanedUp = Collections.nonNullElements(target);
        if (Collections.isEmpty((Iterable)cleanedUp)) {
            return java.util.Collections.emptyList();
        }
        if (this.isNestedProperty(propertyName)) {
            String firstPropertyName = this.popPropertyNameFrom(propertyName);
            List<Object> propertyValues = this.propertyValues(firstPropertyName, cleanedUp);
            return this.propertyValues(this.nextPropertyNameFrom(propertyName), propertyValues);
        }
        return this.simplePropertyValues(propertyName, cleanedUp);
    }

    public static List<Object> propertyValuesOf(String propertyName, Collection<?> target) {
        return PropertySupport.instance().propertyValues(propertyName, target);
    }

    public static List<Object> propertyValuesOf(String propertyName, Object[] target) {
        return PropertySupport.instance().propertyValues(propertyName, Arrays.asList(target));
    }

    private List<Object> simplePropertyValues(String propertyName, Collection<?> target) {
        ArrayList<Object> propertyValues = new ArrayList<Object>();
        for (Object e : target) {
            propertyValues.add(this.propertyValue(propertyName, e));
        }
        return java.util.Collections.unmodifiableList(propertyValues);
    }

    private String popPropertyNameFrom(String propertyNameChain) {
        if (!this.isNestedProperty(propertyNameChain)) {
            return propertyNameChain;
        }
        return propertyNameChain.substring(0, propertyNameChain.indexOf(SEPARATOR));
    }

    private String nextPropertyNameFrom(String propertyNameChain) {
        if (!this.isNestedProperty(propertyNameChain)) {
            return "";
        }
        return propertyNameChain.substring(propertyNameChain.indexOf(SEPARATOR) + 1);
    }

    private boolean isNestedProperty(String propertyName) {
        return propertyName.contains(SEPARATOR) && !propertyName.startsWith(SEPARATOR) && !propertyName.endsWith(SEPARATOR);
    }

    private Object propertyValue(String propertyName, Object target) {
        PropertyDescriptor descriptor = Introspection.descriptorForProperty((String)propertyName, (Object)target);
        try {
            return this.javaBeanDescriptor.invokeReadMethod(descriptor, target);
        }
        catch (Throwable unexpected) {
            String msg = String.format("Unable to obtain the value of the property <'%s'> from <%s>", propertyName, target);
            throw new IntrospectionError(msg, unexpected);
        }
    }
}

