/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.core.ArraySortedAssert;
import org.fest.assertions.core.EnumerableAssert;
import org.fest.assertions.data.Index;
import org.fest.assertions.internal.CharArrays;
import org.fest.util.ComparatorBasedComparisonStrategy;
import org.fest.util.ComparisonStrategy;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharArrayAssert
extends AbstractAssert<CharArrayAssert, char[]>
implements EnumerableAssert<CharArrayAssert, Character>,
ArraySortedAssert<CharArrayAssert, Character> {
    @VisibleForTesting
    CharArrays arrays = CharArrays.instance();

    protected CharArrayAssert(char[] actual) {
        super(actual, CharArrayAssert.class);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (char[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (char[])this.actual);
    }

    @Override
    public CharArrayAssert isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (char[])this.actual);
        return this;
    }

    @Override
    public CharArrayAssert hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (char[])this.actual, expected);
        return this;
    }

    public CharArrayAssert contains(char ... values) {
        this.arrays.assertContains(this.info, (char[])this.actual, values);
        return this;
    }

    public CharArrayAssert containsOnly(char ... values) {
        this.arrays.assertContainsOnly(this.info, (char[])this.actual, values);
        return this;
    }

    public CharArrayAssert containsSequence(char ... sequence) {
        this.arrays.assertContainsSequence(this.info, (char[])this.actual, sequence);
        return this;
    }

    public CharArrayAssert contains(char value, Index index) {
        this.arrays.assertContains(this.info, (char[])this.actual, value, index);
        return this;
    }

    public CharArrayAssert doesNotContain(char ... values) {
        this.arrays.assertDoesNotContain(this.info, (char[])this.actual, values);
        return this;
    }

    public CharArrayAssert doesNotContain(char value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (char[])this.actual, value, index);
        return this;
    }

    public CharArrayAssert doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (char[])this.actual);
        return this;
    }

    public CharArrayAssert startsWith(char ... sequence) {
        this.arrays.assertStartsWith(this.info, (char[])this.actual, sequence);
        return this;
    }

    public CharArrayAssert endsWith(char ... sequence) {
        this.arrays.assertEndsWith(this.info, (char[])this.actual, sequence);
        return this;
    }

    @Override
    public CharArrayAssert isSorted() {
        this.arrays.assertIsSorted(this.info, (char[])this.actual);
        return this;
    }

    @Override
    public CharArrayAssert isSortedAccordingTo(Comparator<? super Character> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (char[])this.actual, comparator);
        return this;
    }

    @Override
    public CharArrayAssert usingElementComparator(Comparator<? super Character> customComparator) {
        this.arrays = new CharArrays((ComparisonStrategy)new ComparatorBasedComparisonStrategy(customComparator));
        return (CharArrayAssert)this.myself;
    }

    @Override
    public CharArrayAssert usingDefaultElementComparator() {
        this.arrays = CharArrays.instance();
        return (CharArrayAssert)this.myself;
    }
}

