/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import org.fest.assertions.api.AbstractComparableAssert;
import org.fest.assertions.core.NumberAssert;
import org.fest.assertions.internal.Shorts;
import org.fest.util.ComparatorBasedComparisonStrategy;
import org.fest.util.ComparisonStrategy;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortAssert
extends AbstractComparableAssert<ShortAssert, Short>
implements NumberAssert<Short> {
    @VisibleForTesting
    Shorts shorts = Shorts.instance();

    protected ShortAssert(Short actual) {
        super(actual, ShortAssert.class);
    }

    @Override
    public ShortAssert isEqualTo(short expected) {
        this.shorts.assertEqual(this.info, this.actual, expected);
        return this;
    }

    @Override
    public ShortAssert isNotEqualTo(short other) {
        this.shorts.assertNotEqual(this.info, this.actual, other);
        return this;
    }

    public ShortAssert isZero() {
        this.shorts.assertIsZero(this.info, (Comparable)this.actual);
        return this;
    }

    public ShortAssert isNotZero() {
        this.shorts.assertIsNotZero(this.info, (Comparable)this.actual);
        return this;
    }

    public ShortAssert isPositive() {
        this.shorts.assertIsPositive(this.info, (Comparable)this.actual);
        return this;
    }

    public ShortAssert isNegative() {
        this.shorts.assertIsNegative(this.info, (Comparable)this.actual);
        return this;
    }

    public ShortAssert isNotNegative() {
        this.shorts.assertIsNotNegative(this.info, (Comparable)this.actual);
        return this;
    }

    public ShortAssert isNotPositive() {
        this.shorts.assertIsNotPositive(this.info, (Comparable)this.actual);
        return this;
    }

    @Override
    public ShortAssert isLessThan(short other) {
        this.shorts.assertLessThan(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public ShortAssert isLessThanOrEqualTo(short other) {
        this.shorts.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public ShortAssert isGreaterThan(short other) {
        this.shorts.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public ShortAssert isGreaterThanOrEqualTo(short other) {
        this.shorts.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public ShortAssert usingComparator(Comparator<? super Short> customComparator) {
        super.usingComparator(customComparator);
        this.shorts = new Shorts((ComparisonStrategy)new ComparatorBasedComparisonStrategy(customComparator));
        return (ShortAssert)this.myself;
    }

    @Override
    public ShortAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.shorts = Shorts.instance();
        return (ShortAssert)this.myself;
    }
}

