/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.core;

import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.core.DescriptionValidations;
import org.fest.assertions.description.Description;
import org.fest.util.Strings;

public final class WritableAssertionInfo
implements AssertionInfo {
    private String overridingErrorMessage;
    private Description description;

    public String overridingErrorMessage() {
        return this.overridingErrorMessage;
    }

    public void overridingErrorMessage(String newErrorMessage) {
        this.overridingErrorMessage = newErrorMessage;
    }

    public Description description() {
        return this.description;
    }

    public String descriptionText() {
        return this.description != null ? this.description.value() : null;
    }

    public void description(String newDescription) {
        this.description = DescriptionValidations.checkIsNotNull(newDescription);
    }

    public void description(Description newDescription) {
        this.description = DescriptionValidations.checkIsNotNull(newDescription);
    }

    public String toString() {
        String format = "%s[overridingErrorMessage=%s, description=%s]";
        return String.format(format, this.getClass().getSimpleName(), Strings.quote((String)this.overridingErrorMessage()), Strings.quote((String)this.descriptionText()));
    }
}

