/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.error;

import org.fest.assertions.description.Description;
import org.fest.assertions.error.ErrorMessageFactory;
import org.fest.assertions.error.MessageFormatter;
import org.fest.util.Arrays;
import org.fest.util.Objects;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

public class BasicErrorMessageFactory
implements ErrorMessageFactory {
    private final String format;
    private final Object[] arguments;
    @VisibleForTesting
    MessageFormatter formatter = MessageFormatter.instance();

    public BasicErrorMessageFactory(String format, Object ... arguments) {
        this.format = format;
        this.arguments = arguments;
    }

    public String create(Description d) {
        return this.formatter.format(d, this.format, this.arguments);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicErrorMessageFactory other = (BasicErrorMessageFactory)obj;
        if (!Objects.areEqual((Object)this.format, (Object)other.format)) {
            return false;
        }
        return Objects.areEqual((Object)this.arguments, (Object)other.arguments);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCodeFor((Object)this.format);
        result = 31 * result + java.util.Arrays.hashCode(this.arguments);
        return result;
    }

    public String toString() {
        return String.format("%s[format=%s, arguments=%s]", this.getClass().getSimpleName(), Strings.quote((String)this.format), Arrays.format((Object)this.arguments));
    }
}

