/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;

public class RenderOption
implements IRenderOption {
    protected HashMap options = new HashMap();

    public RenderOption() {
        this.options = new HashMap();
    }

    public RenderOption(HashMap options) {
        this.options = options;
    }

    public RenderOption(IRenderOption options) {
        this.options = options.getOptions();
    }

    public void setOption(String name, Object value) {
        this.options.put(name, value);
    }

    public Object getOption(String name) {
        return this.options.get(name);
    }

    public boolean hasOption(String name) {
        return this.options.containsKey(name);
    }

    public HashMap getOptions() {
        return this.options;
    }

    public HashMap getOutputSetting() {
        return this.options;
    }

    protected String getStringOption(String name) {
        Object value = this.options.get(name);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    protected boolean getBooleanOption(String name, boolean defaultValue) {
        Object value = this.options.get(name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return "true".equalsIgnoreCase((String)value);
        }
        return defaultValue;
    }

    public String getOutputFormat() {
        return this.getStringOption("Format");
    }

    public void setOutputFormat(String format) {
        this.setOption("Format", format);
    }

    public String getEmitterID() {
        return this.getStringOption("emitterID");
    }

    public void setEmitterID(String emitterId) {
        this.setOption("emitterID", emitterId);
    }

    public void setOutputStream(OutputStream ostream) {
        this.setOption("outputStream", ostream);
    }

    public OutputStream getOutputStream() {
        Object out = this.getOption("outputStream");
        if (out instanceof OutputStream) {
            return (OutputStream)out;
        }
        return null;
    }

    public void setOutputFileName(String outputFileName) {
        this.setOption("outputFile", outputFileName);
    }

    public String getOutputFileName() {
        return this.getStringOption("outputFile");
    }

    public void setSupportedImageFormats(String formats) {
        this.setOption("supportedImageFormats", formats);
    }

    public String getSupportedImageFormats() {
        return this.getStringOption("supportedImageFormats");
    }

    public String getBaseURL() {
        return this.getStringOption("baseUrl");
    }

    public void setBaseURL(String baseURL) {
        this.setOption("baseUrl", baseURL);
    }

    public void setActionHandle(IHTMLActionHandler handler) {
        this.setActionHandler(handler);
    }

    public void setActionHandler(IHTMLActionHandler handler) {
        this.setOption("actionHandler", handler);
    }

    public IHTMLActionHandler getActionHandle() {
        return this.getActionHandler();
    }

    public IHTMLActionHandler getActionHandler() {
        Object handler = this.getOption("actionHandler");
        if (handler instanceof IHTMLActionHandler) {
            return (IHTMLActionHandler)handler;
        }
        return null;
    }

    public void setImageHandle(IHTMLImageHandler handler) {
        this.setImageHandler(handler);
    }

    public void setImageHandler(IHTMLImageHandler handler) {
        this.setOption("imageHandler", handler);
    }

    public IHTMLImageHandler getImageHandle() {
        return this.getImageHandler();
    }

    public IHTMLImageHandler getImageHandler() {
        Object handler = this.getOption("imageHandler");
        if (handler instanceof IHTMLImageHandler) {
            return (IHTMLImageHandler)handler;
        }
        return null;
    }
}

