/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.sql.Time;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;

public class ReportParameterConverter {
    private String format = null;
    private ULocale uLocale = null;
    private StringFormatter sf = null;
    private DateFormatter df = null;
    private NumberFormatter nf = null;

    public ReportParameterConverter(String format, Locale locale) {
        this(format, ULocale.forLocale((Locale)locale));
    }

    public ReportParameterConverter(String format, ULocale uLocale) {
        this.format = format;
        this.uLocale = uLocale;
    }

    private StringFormatter getStringFormatter() {
        if (this.sf == null && this.uLocale != null) {
            this.sf = new StringFormatter(this.uLocale);
            if (this.format != null) {
                this.sf.applyPattern(this.format);
            }
        }
        return this.sf;
    }

    private NumberFormatter getNumberFormatter() {
        if (this.nf == null && this.uLocale != null) {
            this.nf = new NumberFormatter(this.uLocale);
            if (this.format != null) {
                this.nf.applyPattern(this.format);
            }
        }
        return this.nf;
    }

    private DateFormatter getDateFormatter() {
        if (this.df == null && this.uLocale != null) {
            this.df = new DateFormatter(this.uLocale);
            if (this.format != null) {
                this.df.applyPattern(this.format);
            }
        }
        return this.df;
    }

    public String format(Object reportParameterObj) {
        String reportParameterValue = null;
        if (reportParameterObj != null && this.uLocale != null) {
            NumberFormatter nf;
            DateFormatter df;
            StringFormatter sf;
            reportParameterValue = reportParameterObj instanceof String ? ((sf = this.getStringFormatter()) != null ? sf.format((String)reportParameterObj) : reportParameterObj.toString()) : (reportParameterObj instanceof Date ? ((df = this.getDateFormatter()) != null ? df.format((Date)reportParameterObj) : reportParameterObj.toString()) : (reportParameterObj instanceof Double ? ((nf = this.getNumberFormatter()) != null ? nf.format(((Double)reportParameterObj).doubleValue()) : reportParameterObj.toString()) : (reportParameterObj instanceof BigDecimal ? ((nf = this.getNumberFormatter()) != null ? nf.format((BigDecimal)reportParameterObj) : reportParameterObj.toString()) : (reportParameterObj instanceof Boolean ? ((Boolean)reportParameterObj).toString() : (reportParameterObj instanceof Number ? ((nf = this.getNumberFormatter()) != null ? nf.format((Number)reportParameterObj) : reportParameterObj.toString()) : reportParameterObj.toString())))));
        }
        return reportParameterValue;
    }

    public Object parse(String reportParameterValue, int parameterValueType) {
        Object parameterValueObj = null;
        if (reportParameterValue != null && this.uLocale != null) {
            switch (parameterValueType) {
                case 1: {
                    StringFormatter sf = this.getStringFormatter();
                    if (sf == null) {
                        parameterValueObj = null;
                        break;
                    }
                    try {
                        parameterValueObj = sf.parser(reportParameterValue);
                    }
                    catch (ParseException parseException) {
                        parameterValueObj = reportParameterValue;
                    }
                    break;
                }
                case 4: {
                    parameterValueObj = this.parseDateTime(reportParameterValue);
                    break;
                }
                case 2: {
                    NumberFormatter nf = this.getNumberFormatter();
                    if (nf == null) {
                        parameterValueObj = null;
                        break;
                    }
                    try {
                        Number num = nf.parse(reportParameterValue);
                        if (num == null) break;
                        parameterValueObj = new Double(num.toString());
                    }
                    catch (ParseException parseException) {
                        nf.applyPattern("General Number");
                        try {
                            Number num = nf.parse(reportParameterValue);
                            if (num == null) break;
                            parameterValueObj = new Double(num.toString());
                        }
                        catch (ParseException parseException2) {
                            parameterValueObj = null;
                        }
                    }
                    break;
                }
                case 3: {
                    NumberFormatter nf = this.getNumberFormatter();
                    if (nf == null) {
                        parameterValueObj = null;
                        break;
                    }
                    try {
                        Number num = nf.parse(reportParameterValue);
                        if (num == null) break;
                        parameterValueObj = new BigDecimal(num.toString());
                    }
                    catch (ParseException parseException) {
                        nf.applyPattern("General Number");
                        try {
                            Number num = nf.parse(reportParameterValue);
                            if (num == null) break;
                            parameterValueObj = new BigDecimal(num.toString());
                        }
                        catch (ParseException parseException3) {
                            parameterValueObj = null;
                        }
                    }
                    break;
                }
                case 5: {
                    parameterValueObj = Boolean.valueOf(reportParameterValue);
                    break;
                }
                case 7: {
                    try {
                        parameterValueObj = java.sql.Date.valueOf(reportParameterValue);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        parameterValueObj = this.parseDateTime(reportParameterValue);
                        if (parameterValueObj == null) break;
                        parameterValueObj = new java.sql.Date(((Date)parameterValueObj).getTime());
                    }
                    break;
                }
                case 8: {
                    try {
                        parameterValueObj = Time.valueOf(reportParameterValue);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        parameterValueObj = this.parseDateTime(reportParameterValue);
                        if (parameterValueObj == null) break;
                        parameterValueObj = new Time(((Date)parameterValueObj).getTime());
                    }
                    break;
                }
                case 6: {
                    NumberFormatter nf = this.getNumberFormatter();
                    if (nf == null) {
                        parameterValueObj = null;
                        break;
                    }
                    try {
                        Number num = nf.parse(reportParameterValue);
                        if (num == null) break;
                        parameterValueObj = new Integer(num.intValue());
                        break;
                    }
                    catch (ParseException parseException) {
                        nf.applyPattern("General Number");
                        try {
                            Number num = nf.parse(reportParameterValue);
                            if (num == null) break;
                            parameterValueObj = new Integer(num.intValue());
                            break;
                        }
                        catch (ParseException parseException4) {
                            try {
                                parameterValueObj = new Integer(reportParameterValue);
                                break;
                            }
                            catch (NumberFormatException numberFormatException) {
                                parameterValueObj = null;
                            }
                        }
                    }
                }
            }
        }
        return parameterValueObj;
    }

    protected Object parseDateTime(String reportParameterValue) {
        DateFormatter df = this.getDateFormatter();
        if (df == null) {
            return null;
        }
        try {
            return df.parse(reportParameterValue);
        }
        catch (ParseException parseException) {
            df = new DateFormatter("Short Date", this.uLocale);
            try {
                return df.parse(reportParameterValue);
            }
            catch (ParseException parseException2) {
                df = new DateFormatter("Medium Time", this.uLocale);
                try {
                    return df.parse(reportParameterValue);
                }
                catch (ParseException parseException3) {
                    return null;
                }
            }
        }
    }
}

