/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.ULocale;
import java.util.Comparator;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.ReportParameterConverter;

public class SelectionChoiceComparator
implements Comparator {
    private boolean sortDirection = true;
    protected boolean sortDisplayValue;
    protected String format = null;
    protected ULocale locale = null;

    public SelectionChoiceComparator(boolean sortDisplayValue, String format, ULocale locale) {
        this.sortDisplayValue = sortDisplayValue;
        this.format = format;
        this.locale = locale;
        if (this.locale == null) {
            this.locale = ULocale.getDefault();
        }
    }

    public SelectionChoiceComparator(boolean sortDisplayValue, String format, boolean sortDirection, ULocale locale) {
        this.sortDirection = sortDirection;
        this.sortDisplayValue = sortDisplayValue;
        this.format = format;
        this.locale = locale;
        if (this.locale == null) {
            this.locale = ULocale.getDefault();
        }
    }

    public int compare(Object o1, Object o2) {
        int compareResult = -1;
        if (o1 instanceof IParameterSelectionChoice && o2 instanceof IParameterSelectionChoice) {
            Object value2;
            Object value1;
            if (this.sortDisplayValue) {
                value1 = ((IParameterSelectionChoice)o1).getLabel();
                value2 = ((IParameterSelectionChoice)o2).getLabel();
                if (value1 == null) {
                    value1 = this.getDisplayValue(((IParameterSelectionChoice)o1).getValue());
                }
                if (value2 == null) {
                    value2 = this.getDisplayValue(((IParameterSelectionChoice)o2).getValue());
                }
            } else {
                value1 = ((IParameterSelectionChoice)o1).getValue();
                value2 = ((IParameterSelectionChoice)o2).getValue();
            }
            if (value1 == value2) {
                return 0;
            }
            if (value1 == null) {
                return -1;
            }
            if (value2 == null) {
                return 1;
            }
            if (value1 instanceof Boolean && value2 instanceof Boolean) {
                compareResult = (Boolean)value1 ^ (Boolean)value1 ? 0 : ((Boolean)value1 != false ? 1 : -1);
                return this.resultByDirection(compareResult);
            }
            if (value1 instanceof Comparable || value2 instanceof Comparable) {
                compareResult = value1 instanceof Comparable ? ((Comparable)value1).compareTo(value2) : -((Comparable)value2).compareTo(value1);
                return this.resultByDirection(compareResult);
            }
        }
        return this.resultByDirection(compareResult);
    }

    private int resultByDirection(int compareResult) {
        if (this.sortDirection) {
            return compareResult;
        }
        return -compareResult;
    }

    private String getDisplayValue(Object value) {
        if (value == null) {
            return null;
        }
        ReportParameterConverter converter = new ReportParameterConverter(this.format, this.locale);
        return converter.format(value);
    }
}

