/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.doc.schema;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.birt.doc.schema.CssType;
import org.eclipse.birt.doc.schema.ISchemaWriter;
import org.eclipse.birt.doc.schema.SchemaUtil;

public class CssSchemaWriter
implements ISchemaWriter {
    protected PrintStream out = null;
    protected static final String OUTPUT_ENCODING = "UTF-8";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.doc.schema.CssSchemaWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private CssSchemaWriter() {
    }

    public CssSchemaWriter(File outputFile) throws IOException {
        FileOutputStream stream = new FileOutputStream(outputFile);
        this.out = new PrintStream((OutputStream)stream, false, OUTPUT_ENCODING);
    }

    public CssSchemaWriter(File outputFile, String signature) throws IOException {
        FileOutputStream stream = new FileOutputStream(outputFile);
        this.out = new PrintStream((OutputStream)stream, false, signature);
    }

    public void close() {
        this.out.close();
        this.out = null;
    }

    public void startHtml() {
        this.out.print("<html>");
        this.printLine();
        this.out.print("<body>");
        this.printLine();
        this.out.print("<h1>BIRT Css full property table");
        this.printLine();
        this.initTable();
    }

    private void initTable() {
        this.out.print("<table border = 1> ");
        this.printLine();
        this.out.print("<thead><tr align=center>");
        this.out.print("<th>Name</th>");
        this.out.print("<th>W3C Values</th>");
        this.out.print("<th>Default Value</th>");
        this.out.print("<th>BIRT Choice Values</th>");
        this.out.print("</tr></thead>");
        this.printLine();
    }

    public void closeHtml() {
        this.out.print("</table>");
        this.printLine();
        this.out.print("</body>");
        this.printLine();
        this.out.print("</html>");
        this.printLine();
    }

    public void writeRow(CssType css) {
        if (!$assertionsDisabled && css == null) {
            throw new AssertionError();
        }
        String allowedValue = css.getBirtChoiceValues();
        String defaultValue = css.getInitialValues();
        String htmlValue = css.getValues();
        String name = css.getName();
        if (SchemaUtil.isBlank(name)) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<tr><td>");
        buffer.append(name);
        this.appendColumn(buffer, htmlValue);
        this.appendColumn(buffer, defaultValue);
        this.appendColumn(buffer, allowedValue);
        this.out.print(buffer.toString());
        this.printLine();
    }

    private void appendColumn(StringBuffer buffer, String value) {
        if (!SchemaUtil.isBlank(value)) {
            buffer.append("<td>");
            buffer.append(value);
        } else {
            buffer.append("<td>&nbsp;");
        }
    }

    private void printLine() {
        this.out.print('\n');
    }
}

