/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.NameEvent;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencableElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.namespace.INameHelper;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;

public class NameSpaceRecord
extends SimpleRecord {
    protected INameHelper nameHelper = null;
    protected DesignElement element = null;
    protected int nameSpaceID = 0;
    protected boolean add = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.command.NameSpaceRecord");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public NameSpaceRecord(INameHelper nameHelper, int ns, DesignElement symbol, boolean isAdd) {
        this.nameHelper = nameHelper;
        this.nameSpaceID = ns;
        this.element = symbol;
        this.add = isAdd;
        if (!$assertionsDisabled && this.element == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && nameHelper == null) {
            throw new AssertionError();
        }
        this.label = this.add ? ModelMessages.getMessage("Message.InsertElement") : ModelMessages.getMessage("Message.DeleteElement");
    }

    protected void perform(boolean undo) {
        int nameSpaceID = ((ElementDefn)this.element.getDefn()).getNameSpaceID();
        Module root = this.nameHelper.getElement().getRoot();
        NameSpace ns = this.nameHelper.getNameSpace(nameSpaceID);
        if (!$assertionsDisabled && root == null) {
            throw new AssertionError();
        }
        if (this.add && !undo || !this.add && undo) {
            if (this.element instanceof IReferencableElement) {
                IReferencableElement originalElement = (IReferencableElement)((Object)root.resolveElement(this.element.getName(), null, this.element.getDefn()));
                ns.insert(this.element);
                this.nameHelper.dropElement(this.element);
                if (originalElement != null) {
                    this.updateAllElementReferences(root, originalElement);
                }
            } else {
                ns.insert(this.element);
                this.nameHelper.dropElement(this.element);
            }
        } else {
            ns.remove(this.element);
            if (this.element instanceof ReferenceableElement) {
                this.updateAllElementReferences(root, (ReferenceableElement)this.element);
            }
        }
    }

    private void updateAllElementReferences(Module root, IReferencableElement referred) {
        List clients = referred.getClientList();
        Iterator iter = clients.iterator();
        block0: while (iter.hasNext()) {
            BackRef ref = (BackRef)iter.next();
            DesignElement client = ref.getElement();
            Structure struct = ref.getStructure();
            if (struct != null) {
                this.updatePropertyListnMemberCase(root, referred, struct, ref.getPropertyName(), client);
                continue;
            }
            Object value = client.getLocalProperty(root, ref.getPropertyName());
            if (value instanceof ElementRefValue) {
                ElementRefValue refValue = (ElementRefValue)value;
                refValue.unresolved(refValue.getName());
                referred.dropClient(client);
                client.resolveElementReference(root, client.getPropertyDefn(ref.getPropertyName()));
                continue;
            }
            if (value instanceof List) {
                List valueList = (List)value;
                int i = 0;
                while (i < valueList.size()) {
                    ElementRefValue item;
                    Object tempObj = valueList.get(i);
                    if (tempObj instanceof ElementRefValue && referred == (item = (ElementRefValue)tempObj).getElement()) {
                        item.unresolved(item.getName());
                        referred.dropClient(client);
                        ReferenceValueUtil.resolveElementReference(root, client, client.getPropertyDefn(ref.getPropertyName()), item);
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            if (!(value instanceof DesignElement) && !$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    private void updatePropertyListnMemberCase(Module root, IReferencableElement referred, Structure struct, String memberName, DesignElement client) {
        ElementRefValue tempRefValue;
        IPropertyDefn propDefn = struct.getDefn().getMember(memberName);
        if (propDefn.getTypeCode() == 15 && referred == (tempRefValue = (ElementRefValue)struct.getLocalProperty(root, (PropertyDefn)propDefn)).getElement()) {
            tempRefValue.unresolved(tempRefValue.getName());
            referred.dropClient(client);
            ReferenceValueUtil.resolveElementReference(struct, root, (StructPropertyDefn)propDefn, (Object)tempRefValue);
        }
    }

    public DesignElement getTarget() {
        return this.nameHelper.getElement();
    }

    public NotificationEvent getEvent() {
        NameEvent event = null;
        event = this.add ? new NameEvent(this.element, null, this.element.getName()) : new NameEvent(this.element, this.element.getName(), null);
        return event;
    }
}

