/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.extension.IReportItemFactory;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.interfaces.IStyleModel;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.PredefinedStyle;

public class Style
extends StyleElement
implements IStyleModel {
    public Style() {
    }

    public Style(String theName) {
        super(theName);
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitStyle(this);
    }

    public String getElementName() {
        return "Style";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public SharedStyleHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new SharedStyleHandle(module, this);
        }
        return (SharedStyleHandle)this.handle;
    }

    public List validate(Module module) {
        List list = super.validate(module);
        list.addAll(Style.validateStyleProperties(module, this));
        return list;
    }

    public static List validateStyleProperties(Module module, DesignElement element) {
        ArrayList list = new ArrayList();
        List rules = element.getListProperty(module, "highlightRules");
        if (rules != null) {
            int i = 0;
            while (i < rules.size()) {
                list.addAll(((HighlightRule)rules.get(i)).validate(module, element));
                ++i;
            }
        }
        return list;
    }

    public String getDisplayLabel(Module module, int level) {
        MetaDataDictionary meta = MetaDataDictionary.getInstance();
        PredefinedStyle selector = meta.getPredefinedStyle(this.name);
        if (selector == null) {
            return super.getDisplayLabel(module, level);
        }
        List elementDefns = meta.getExtensions();
        ElementDefn elementDefn = null;
        int i = 0;
        while (i < elementDefns.size()) {
            ElementDefn tmpElementDefn = (ElementDefn)elementDefns.get(i);
            if (this.name.equalsIgnoreCase(tmpElementDefn.getSelector())) {
                elementDefn = tmpElementDefn;
                break;
            }
            ++i;
        }
        String displayLabel = null;
        if (elementDefn != null) {
            if (!(elementDefn instanceof PeerExtensionElementDefn)) {
                throw new IllegalOperationException("Only report item extension can be created through this method.");
            }
            PeerExtensionElementDefn extDefn = (PeerExtensionElementDefn)elementDefn;
            IReportItemFactory reportItemFactory = extDefn.getReportItemFactory();
            if (reportItemFactory == null) {
                return super.getDisplayLabel(module, level);
            }
            IMessages msgs = reportItemFactory.getMessages();
            if (msgs == null) {
                return super.getDisplayLabel(module, level);
            }
            displayLabel = msgs.getMessage(selector.getDisplayNameKey(), ThreadResources.getLocale());
        } else {
            displayLabel = ModelMessages.getMessage(selector.getDisplayNameKey());
        }
        if (StringUtil.isBlank(displayLabel)) {
            displayLabel = super.getDisplayLabel(module, level);
        }
        return displayLabel;
    }
}

