/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.strategy.GroupPropSearchStrategy;
import org.eclipse.birt.report.model.elements.strategy.ReportItemPropSearchStrategy;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.util.ModelUtil;

public class RecoverDataGroupUtil {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.parser.RecoverDataGroupUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    static void checkListingGroup(ListingElement listing, ModuleParserHandler tmpHandler) {
        int targetGroupCount;
        ElementRefValue refValue = (ElementRefValue)listing.getLocalProperty(tmpHandler.module, "dataBindingRef");
        if (!$assertionsDisabled && refValue == null) {
            throw new AssertionError();
        }
        tmpHandler.addUnresolveListingElement(listing);
        if (!refValue.isResolved()) {
            return;
        }
        DesignElement targetElement = refValue.getElement();
        if (!ModelUtil.isCompatibleDataBindingElements(listing, targetElement)) {
            return;
        }
        int elementGroupCount = listing.getGroups().size();
        if (elementGroupCount != (targetGroupCount = ((ListingElement)targetElement).getGroups().size())) {
            RecoverDataGroupUtil.recoverListingElement(listing, (ListingElement)targetElement, tmpHandler);
            tmpHandler.getErrorHandler().semanticWarning((Exception)((Object)new SemanticError((DesignElement)listing, new String[]{listing.getIdentifier(), targetElement.getIdentifier()}, "Error.SemanticError.INCONSISTENT_DATA_GROUP", 1)));
        }
    }

    private static void recoverListingElement(ListingElement listing, ListingElement targetElement, ModuleParserHandler tmpHandler) {
        RecoverDataGroupUtil.recoverReferredReportItem(listing, targetElement, tmpHandler);
        List listingGroups = listing.getGroups();
        List targetGroups = targetElement.getGroups();
        int size = Math.min(listingGroups.size(), targetGroups.size());
        int i = 0;
        while (i < size) {
            RecoverDataGroupUtil.recoverReferredReportItem((GroupElement)listingGroups.get(i), (GroupElement)targetGroups.get(i), tmpHandler);
            ++i;
        }
        listing.setProperty("dataBindingRef", null);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private static void recoverReferredReportItem(DesignElement source, DesignElement targetElement, ModuleParserHandler tmpHandler) {
        Iterator propNames = null;
        if (targetElement instanceof ListingElement) {
            propNames = ReportItemPropSearchStrategy.getDataBindingPropties().iterator();
        } else {
            if (!(targetElement instanceof GroupElement)) {
                if ($assertionsDisabled) return;
                throw new AssertionError();
            }
            propNames = GroupPropSearchStrategy.getDataBindingPropties().iterator();
        }
        while (propNames.hasNext()) {
            String propName = (String)propNames.next();
            ElementPropertyDefn propDefn = (ElementPropertyDefn)targetElement.getDefn().getProperty(propName);
            source.setProperty(propName, targetElement.getStrategy().getPropertyExceptRomDefault(tmpHandler.module, targetElement, propDefn));
        }
    }
}

