/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;

public class SingleElementSlot
extends ContainerSlot {
    private DesignElement content = null;

    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        SingleElementSlot slot = (SingleElementSlot)super.clone();
        if (this.content != null) {
            slot.content = (DesignElement)this.content.doClone(policy);
        }
        return slot;
    }

    public int findPosn(DesignElement element) {
        if (element != null && element == this.content) {
            return 0;
        }
        return -1;
    }

    public void insert(DesignElement element, int posn) {
        assert (this.content == null);
        assert (element != null);
        assert (posn == 0);
        this.content = element;
    }

    public void remove(DesignElement element) {
        assert (this.content != null && this.content == element);
        this.content = null;
    }

    public Object remove(int posn) {
        assert (posn == 0);
        this.content = null;
        return null;
    }

    public boolean canDrop(DesignElement element) {
        assert (this.content != null && this.content == element);
        return true;
    }

    public List getContents() {
        ArrayList<DesignElement> list = new ArrayList<DesignElement>();
        if (this.content != null) {
            list.add(this.content);
        }
        return list;
    }

    public int getCount() {
        return this.content == null ? 0 : 1;
    }

    public void moveContent(int from, int to) {
        assert (false);
    }

    public boolean contains(DesignElement element) {
        return element != null && this.content == element;
    }

    public DesignElement getContent(int pos) {
        assert (pos == 0 && this.content != null);
        return this.content;
    }

    public void clear() {
        this.content = null;
    }
}

