/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.ElementReferenceValidator;
import org.eclipse.birt.report.model.api.validators.SimpleListValidator;
import org.eclipse.birt.report.model.api.validators.StructureListValidator;
import org.eclipse.birt.report.model.api.validators.StructureReferenceValidator;
import org.eclipse.birt.report.model.api.validators.StructureValidator;
import org.eclipse.birt.report.model.api.validators.ValueRequiredValidator;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.ObjectDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefn;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefnSet;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.validators.AbstractPropertyValidator;
import org.eclipse.birt.report.model.validators.ISemanticTriggerDefnSetProvider;

public abstract class PropertyDefn
implements IPropertyDefn,
ISemanticTriggerDefnSetProvider {
    public static List supportedSubTypes = null;
    protected ObjectDefn definedBy = null;
    protected PropertyType type = null;
    protected PropertyType subType = null;
    protected String name = null;
    protected String displayNameID = null;
    protected String defaultUnit = "";
    protected Object details = null;
    protected boolean intrinsic = false;
    protected Object defaultValue = null;
    protected ChoiceSet allowedChoices = null;
    protected ChoiceSet allowedUnits = null;
    protected boolean isList = false;
    protected String valueValidator = null;
    private SemanticTriggerDefnSet triggers = null;
    private boolean valueRequired = false;
    private boolean isEncryptable = false;
    protected String since = "none";
    protected boolean runtimeSettable;
    protected String context;
    protected String returnType;

    public void setOwner(ObjectDefn owner) {
        this.definedBy = owner;
    }

    public ObjectDefn definedBy() {
        return this.definedBy;
    }

    public abstract int getValueType();

    protected void build() throws MetaDataException {
        this.buildDefn();
        this.buildTriggerDefnSet();
    }

    protected final void buildTriggerDefnSet() throws MetaDataException {
        this.getTriggerDefnSet().build();
    }

    protected final void buildDefn() throws MetaDataException {
        IChoiceSet units;
        IChoice choice;
        String defaultUnit;
        MetaDataDictionary dict;
        if (this.getType() == null) {
            throw new MetaDataException(new String[]{this.name}, "PROP_TYPE_ERROR");
        }
        this.displayNameID = StringUtil.trimString(this.displayNameID);
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        switch (this.getTypeCode()) {
            case 5: {
                IChoiceSet choiceSet = this.getChoices();
                if (choiceSet != null && choiceSet.getChoices() != null) break;
                throw new MetaDataException(new String[]{this.name}, "MISSING_PROP_CHOICES");
            }
            case 16: {
                SemanticTriggerDefn triggerDefn;
                AbstractPropertyValidator validator;
                StructureDefn structDefn;
                if (this.details == null) {
                    throw new MetaDataException(new String[]{this.name, this.definedBy().getName()}, "MISSING_STRUCT_DEFN");
                }
                if (this.details instanceof String) {
                    structDefn = (StructureDefn)dd.getStructure(StringUtil.trimString((String)this.details));
                    this.details = structDefn;
                }
                if (this.isList()) {
                    validator = StructureListValidator.getInstance();
                    triggerDefn = new SemanticTriggerDefn("StructureListValidator");
                    triggerDefn.setPropertyName(this.getName());
                    triggerDefn.setValidator(validator);
                    this.getTriggerDefnSet().add(triggerDefn);
                    break;
                }
                validator = StructureValidator.getInstance();
                triggerDefn = new SemanticTriggerDefn("StructureValidator");
                triggerDefn.setPropertyName(this.getName());
                triggerDefn.setValidator(validator);
                this.getTriggerDefnSet().add(triggerDefn);
                break;
            }
            case 15: {
                this.buildElementType();
                break;
            }
            case 19: {
                StructureDefn structDefn;
                if (this.details == null) {
                    throw new MetaDataException(new String[]{this.name}, "MISSING_STRUCT_DEFN");
                }
                if (this.details instanceof String) {
                    structDefn = (StructureDefn)dd.getStructure(StringUtil.trimString((String)this.details));
                    this.details = structDefn;
                }
                IElementDefn report = dd.getElement("ReportDesign");
                List properties = report.getProperties();
                boolean isFound = false;
                int i = 0;
                while (i < properties.size()) {
                    IPropertyDefn property = (IPropertyDefn)properties.get(i);
                    if (property.getTypeCode() == 16 && property.getStructDefn() == this.getStructDefn()) {
                        isFound = true;
                        break;
                    }
                    ++i;
                }
                if (!isFound) {
                    throw new MetaDataException(new String[]{this.name}, "UNREFERENCABLE_STRUCT_DEFN");
                }
                SemanticTriggerDefn triggerDefn = new SemanticTriggerDefn("StructureReferenceValidator");
                triggerDefn.setPropertyName(this.getName());
                triggerDefn.setValidator(StructureReferenceValidator.getInstance());
                this.getTriggerDefnSet().add(triggerDefn);
                break;
            }
            case 20: {
                if (this.subType == null) {
                    throw new MetaDataException(new String[]{this.name}, "MISSING_SUB_TYPE");
                }
                if (this instanceof StructPropertyDefn && this.subType.getTypeCode() == 15) {
                    throw new MetaDataException(new String[]{this.name, this.subType.getName()}, "UNSUPPORTED_SUB_TYPE");
                }
                if (!PropertyDefn.getSupportedSubTypes().contains(this.subType)) {
                    throw new MetaDataException(new String[]{this.name, this.subType.getName()}, "UNSUPPORTED_SUB_TYPE");
                }
                SimpleListValidator validator = SimpleListValidator.getInstance();
                SemanticTriggerDefn triggerDefn = new SemanticTriggerDefn("SimpleListValidator");
                triggerDefn.setPropertyName(this.getName());
                triggerDefn.setValidator(validator);
                this.getTriggerDefnSet().add(triggerDefn);
                if (this.subType.getTypeCode() != 15) break;
                this.buildElementType();
                break;
            }
            case 23: 
            case 24: {
                if (!(this.details instanceof List)) {
                    throw new MetaDataException(new String[]{this.name, this.type.getName()}, "MISSING_ELEMENT_TYPE");
                }
                List elementNames = (List)this.details;
                if (elementNames.isEmpty()) {
                    throw new MetaDataException(new String[]{this.name, this.type.getName()}, "MISSING_ELEMENT_TYPE");
                }
                ArrayList<ElementDefn> elementTypes = new ArrayList<ElementDefn>();
                int i = 0;
                while (i < elementNames.size()) {
                    String elementName = (String)elementNames.get(i);
                    ElementDefn type = (ElementDefn)dd.getElement(elementName);
                    if (type == null) {
                        throw new MetaDataException(new String[]{elementName, this.name}, "UNDEFINED_ELEMENT_TYPE");
                    }
                    elementTypes.add(type);
                    ++i;
                }
                this.details = elementTypes;
            }
        }
        if (this.isValueRequired()) {
            SemanticTriggerDefn triggerDefn = new SemanticTriggerDefn("ValueRequiredValidator");
            triggerDefn.setPropertyName(this.getName());
            triggerDefn.setValidator(ValueRequiredValidator.getInstance());
            this.getTriggerDefnSet().add(triggerDefn);
        }
        if (this.getTypeCode() != 20 && this.subType != null) {
            throw new MetaDataException(new String[]{this.name}, "SUB_TYPE_FORBIDDEN");
        }
        if (this.getTypeCode() != 16 && this.getTypeCode() != 23 && this.getTypeCode() != 24 && this.isList) {
            throw new MetaDataException(new String[]{this.getType().getName()}, "INVALID_LIST_TYPE");
        }
        if (this.defaultValue != null) {
            try {
                this.validateXml(null, this.defaultValue.toString());
            }
            catch (PropertyValueException propertyValueException) {
                throw new MetaDataException(new String[]{this.name, this.defaultValue.toString()}, "INVALID_DEFAULT_VALUE");
            }
        }
        if (this.valueValidator != null && (dict = MetaDataDictionary.getInstance()).getValueValidator(this.valueValidator) == null) {
            throw new MetaDataException(new String[]{this.valueValidator, this.name}, "VALIDATOR_NOT_FOUND");
        }
        if ((this.getTypeCode() == 3 || this.getTypeCode() == 20 && this.subType.getTypeCode() == 3) && !StringUtil.isBlank(defaultUnit = this.getDefaultUnit()) && (choice = (units = this.getAllowedUnits()).findChoice(defaultUnit)) == null) {
            this.setDefaultUnit("");
            throw new MetaDataException(new String[]{this.getName(), defaultUnit}, "INVALID_UNIT");
        }
    }

    private void buildElementType() throws MetaDataException {
        if (this.details == null) {
            throw new MetaDataException(new String[]{this.name, this.type.getName()}, "MISSING_ELEMENT_TYPE");
        }
        if (this.details instanceof String) {
            MetaDataDictionary dd = MetaDataDictionary.getInstance();
            ElementDefn elementDefn = (ElementDefn)dd.getElement(StringUtil.trimString((String)this.details));
            if (elementDefn == null || "ExtendedItem".equalsIgnoreCase((String)this.details)) {
                throw new MetaDataException(new String[]{(String)this.details, this.name}, "UNDEFINED_ELEMENT_TYPE");
            }
            if (elementDefn.getNameSpaceID() == -1) {
                throw new MetaDataException(new String[]{(String)this.details, this.name}, "UNNAMED_ELEMENT_TYPE");
            }
            this.details = elementDefn;
        } else if (this.getTargetElementType() == null) {
            throw new MetaDataException(new String[]{this.name, this.type.getName()}, "MISSING_ELEMENT_TYPE");
        }
        if (!this.name.equalsIgnoreCase("style")) {
            SemanticTriggerDefn triggerDefn = new SemanticTriggerDefn("ElementReferenceValidator");
            triggerDefn.setPropertyName(this.getName());
            triggerDefn.setValidator(ElementReferenceValidator.getInstance());
            this.getTriggerDefnSet().add(triggerDefn);
        }
    }

    public boolean isSystemProperty() {
        return this.getValueType() == 0;
    }

    public boolean isUserProperty() {
        return this.getValueType() == 1;
    }

    public boolean isStructureMember() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int getTypeCode() {
        assert (this.type != null);
        return this.type.getTypeCode();
    }

    public PropertyType getType() {
        return this.type;
    }

    private String validateExtendedChoicesByName(Object value) {
        if (value == null || !this.hasChoices()) {
            return null;
        }
        IChoiceSet choiceSet = this.getChoices();
        IChoice choice = choiceSet.findChoice(value.toString());
        if (choice != null) {
            return choice.getName();
        }
        return null;
    }

    protected String validateExtendedChoicesByDisplayName(Module module, String displayName) {
        if (displayName == null || !this.hasChoices()) {
            return null;
        }
        IChoiceSet choiceSet = this.getChoices();
        IChoice choice = choiceSet.findChoiceByDisplayName(displayName);
        if (choice != null) {
            return choice.getName();
        }
        return null;
    }

    public Object validateValue(Module module, Object value) throws PropertyValueException {
        Object retValue = null;
        if (this.hasChoices() && this.getTypeCode() != 5) {
            retValue = this.validateExtendedChoicesByName(value);
            if (retValue == null && value != null) {
                retValue = this.validateExtendedChoicesByDisplayName(module, value.toString());
            }
            if (retValue != null) {
                return retValue;
            }
        }
        retValue = this.getType().validateValue(module, this, value);
        if (this.valueValidator != null) {
            MetaDataDictionary.getInstance().getValueValidator(this.valueValidator).validate(module, this, retValue);
        }
        return retValue;
    }

    public Object validateXml(Module module, String value) throws PropertyValueException {
        Object retValue = null;
        if (this.hasChoices() && this.getTypeCode() != 5 && (retValue = this.validateExtendedChoicesByName(value)) != null) {
            return retValue;
        }
        retValue = this.getType().validateXml(module, this, value);
        if (this.valueValidator != null) {
            MetaDataDictionary.getInstance().getValueValidator(this.valueValidator).validate(module, this, retValue);
        }
        return retValue;
    }

    public String getDisplayName() {
        assert (this.displayNameID != null);
        return ModelMessages.getMessage(this.displayNameID);
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public IChoiceSet getChoices() {
        if (this.details instanceof ChoiceSet) {
            return (ChoiceSet)this.details;
        }
        return null;
    }

    public boolean hasChoices() {
        return this.getChoices() != null;
    }

    public String getDisplayNameID() {
        return this.displayNameID;
    }

    public void setDetails(Object obj) {
        this.details = obj;
    }

    public void setDisplayNameID(String id) {
        this.displayNameID = id;
    }

    public String getXmlValue(Module module, Object value) {
        if (value == null) {
            return null;
        }
        String retValue = this.validateExtendedChoicesByName(value);
        return retValue == null ? this.getType().toXml(module, this, value) : retValue;
    }

    public String getStringValue(Module module, Object value) {
        return this.getType().toString(module, this, value);
    }

    public double getFloatValue(Module module, Object value) {
        return this.getType().toDouble(module, value);
    }

    public int getIntValue(Module module, Object value) {
        return this.getType().toInteger(module, value);
    }

    public BigDecimal getNumberValue(Module module, Object value) {
        return this.getType().toNumber(module, value);
    }

    public boolean getBooleanValue(Module module, Object value) {
        return this.getType().toBoolean(module, value);
    }

    public String getDisplayValue(Module module, Object value) {
        if (value == null) {
            return null;
        }
        String retValue = this.validateExtendedChoicesByName(value);
        if (retValue == null) {
            return this.getType().toDisplayString(module, this, value);
        }
        return this.getChoices().findChoice(value.toString()).getDisplayName();
    }

    public void setType(PropertyType typeDefn) {
        this.type = typeDefn;
    }

    public IStructureDefn getStructDefn() {
        if (this.details instanceof StructureDefn) {
            return (StructureDefn)this.details;
        }
        return null;
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    protected void setDefault(Object value) {
        this.defaultValue = value;
    }

    public boolean isIntrinsic() {
        return this.intrinsic;
    }

    void setIntrinsic(boolean flag) {
        this.intrinsic = flag;
    }

    public IElementDefn getTargetElementType() {
        if (this.details instanceof ElementDefn) {
            return (ElementDefn)this.details;
        }
        return null;
    }

    public IChoiceSet getAllowedChoices() {
        if (this.allowedChoices != null) {
            return this.allowedChoices;
        }
        return this.getChoices();
    }

    void setAllowedChoices(ChoiceSet allowedChoices) {
        this.allowedChoices = allowedChoices;
    }

    void setAllowedUnits(ChoiceSet allowedUnits) {
        this.allowedUnits = allowedUnits;
    }

    public IChoiceSet getAllowedUnits() {
        if (this.allowedUnits != null) {
            return this.allowedUnits;
        }
        return MetaDataDictionary.getInstance().getChoiceSet("units");
    }

    void setValueValidator(String validator) {
        this.valueValidator = validator;
    }

    public boolean isExtended() {
        return this.getValueType() == 3 || this.getValueType() == 2;
    }

    public boolean isList() {
        return this.isList;
    }

    protected void setIsList(boolean isList) {
        this.isList = isList;
    }

    public SemanticTriggerDefnSet getTriggerDefnSet() {
        if (this.triggers == null) {
            this.triggers = new SemanticTriggerDefnSet();
        }
        return this.triggers;
    }

    public boolean isValueRequired() {
        return this.valueRequired;
    }

    void setValueRequired(boolean valueRequired) {
        this.valueRequired = valueRequired;
    }

    public String getDefaultUnit() {
        if (this.getTypeCode() != 3) {
            return "";
        }
        return this.defaultUnit;
    }

    void setDefaultUnit(String defaultUnit) {
        assert (this.getTypeCode() == 3);
        this.defaultUnit = defaultUnit;
    }

    public boolean isEncryptable() {
        return this.isEncryptable;
    }

    void setIsEncryptable(boolean isEncryptable) {
        this.isEncryptable = isEncryptable;
    }

    public void setSince(String value) {
        if (!StringUtil.isBlank(value)) {
            this.since = value;
        }
    }

    public String getSince() {
        return this.since;
    }

    public void setRuntimeSettable(boolean flag) {
        this.runtimeSettable = flag;
    }

    public boolean isRuntimeSettable() {
        return this.runtimeSettable;
    }

    public void setContext(String value) {
        this.context = value;
    }

    public String getContext() {
        return this.context;
    }

    public void setReturnType(String type) {
        this.returnType = type;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String toString() {
        if (!StringUtil.isBlank(this.getName())) {
            return this.getName();
        }
        return super.toString();
    }

    public static final List getSupportedSubTypes() {
        if (supportedSubTypes != null && !supportedSubTypes.isEmpty()) {
            return supportedSubTypes;
        }
        supportedSubTypes = new ArrayList();
        for (PropertyType propType : MetaDataDictionary.getInstance().getPropertyTypes()) {
            int type = propType.getTypeCode();
            switch (type) {
                case 0: 
                case 2: 
                case 6: 
                case 7: 
                case 11: 
                case 14: 
                case 15: {
                    supportedSubTypes.add(propType);
                    break;
                }
            }
        }
        return supportedSubTypes;
    }

    void setSubType(PropertyType subType) {
        this.subType = subType;
    }

    public PropertyType getSubType() {
        return this.subType;
    }

    public int getSubTypeCode() {
        if (this.subType != null) {
            return this.subType.getTypeCode();
        }
        return -1;
    }

    public List getAllowedElements() {
        return this.getAllowedElements(true);
    }

    public List getAllowedElements(boolean extractExtensions) {
        if (this.details instanceof List && this.isElementType()) {
            if (!extractExtensions) {
                return Collections.unmodifiableList((List)this.details);
            }
            List allowedElements = (List)this.details;
            MetaDataDictionary dd = MetaDataDictionary.getInstance();
            IElementDefn extendItem = dd.getElement("ExtendedItem");
            ArrayList<ExtensionElementDefn> contentsWithExtensions = new ArrayList<ExtensionElementDefn>();
            contentsWithExtensions.addAll(allowedElements);
            if (allowedElements.contains(extendItem)) {
                contentsWithExtensions.remove(extendItem);
                int i = 0;
                while (i < dd.getExtensions().size()) {
                    ExtensionElementDefn extension = (ExtensionElementDefn)dd.getExtensions().get(i);
                    if (extension.isKindOf(dd.getElement("ReportItem")) && "org.eclipse.birt.report.model.reportItemModel".equals(extension.extensionPoint) && !contentsWithExtensions.contains(extension)) {
                        contentsWithExtensions.add(extension);
                    }
                    ++i;
                }
            }
            return Collections.unmodifiableList(contentsWithExtensions);
        }
        return Collections.EMPTY_LIST;
    }

    public final boolean canContain(IElementDefn type) {
        if (type == null) {
            return false;
        }
        List contentElements = this.getAllowedElements();
        assert (contentElements != null);
        for (ElementDefn element : contentElements) {
            ExtensionElementDefn extensionDefn;
            if (!"ExtendedItem".equals(element.getName())) {
                if (!type.isKindOf(element)) continue;
                return true;
            }
            if (type instanceof ExtensionElementDefn && "org.eclipse.birt.report.model.reportItemModel".equals((extensionDefn = (ExtensionElementDefn)type).getExtensionPoint()) && extensionDefn.isKindOf(MetaDataDictionary.getInstance().getElement("ReportItem"))) {
                return true;
            }
            if (!"ExtendedItem".equals(type.getName())) continue;
            return true;
        }
        return false;
    }

    public final boolean canContain(DesignElement content) {
        return this.canContain(content.getDefn());
    }

    public final boolean isElementType() {
        int typeCode = this.getTypeCode();
        return typeCode == 23 || typeCode == 24;
    }

    public final boolean isListType() {
        if (this.isList) {
            return true;
        }
        int typeCode = this.type.getTypeCode();
        return typeCode == 20;
    }
}

