/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.type.impl;

import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.TypeFactory;
import org.eclipse.birt.chart.model.type.TypePackage;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.emf.ecore.EClass;

public class AreaSeriesImpl
extends LineSeriesImpl
implements AreaSeries {
    protected AreaSeriesImpl() {
    }

    protected EClass eStaticClass() {
        return TypePackage.Literals.AREA_SERIES;
    }

    public void translateFrom(Series series, int iSeriesDefinitionIndex, Chart chart) {
        super.translateFrom(series, iSeriesDefinitionIndex, chart);
        for (Marker mk : this.getMarkers()) {
            mk.unsetVisible();
        }
    }

    public static Series create() {
        AreaSeries as = TypeFactory.eINSTANCE.createAreaSeries();
        ((AreaSeriesImpl)as).initialize();
        return as;
    }

    protected void initialize() {
        super.initialize();
        for (Marker mk : this.getMarkers()) {
            mk.setVisible(false);
        }
    }

    public static Series createDefault() {
        AreaSeries as = TypeFactory.eINSTANCE.createAreaSeries();
        ((AreaSeriesImpl)as).initDefault();
        return as;
    }

    protected void initDefault() {
        super.initDefault();
        for (Marker mk : this.getMarkers()) {
            try {
                ChartElementUtil.setDefaultValue(mk, "visible", false);
            }
            catch (ChartException chartException) {}
        }
    }

    public String getDisplayName() {
        return Messages.getString("AreaSeriesImpl.displayName");
    }

    public AreaSeries copyInstance() {
        AreaSeriesImpl dest = new AreaSeriesImpl();
        dest.set(this);
        return dest;
    }

    protected void set(AreaSeries src) {
        super.set(src);
    }
}

