/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.index;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.index.IDataSetIndex;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetNumberIndex
implements IDataSetIndex {
    private int segNumber;
    private List boundaryStartingValues = new ArrayList();
    private Seg[] segs;

    public DataSetNumberIndex(RAInputStream raIn) throws DataException {
        try {
            this.segNumber = IOUtil.readInt(raIn);
            this.segs = new Seg[this.segNumber];
            this.boundaryStartingValues = new ArrayList();
            long[] offsets = new long[this.segNumber];
            DataInputStream din = new DataInputStream(raIn);
            int i = 0;
            while (i < offsets.length) {
                offsets[i] = IOUtil.readLong(din);
                ++i;
            }
            i = 0;
            while (i < this.segNumber) {
                this.boundaryStartingValues.add(IOUtil.readObject(din));
                this.segs[i] = new Seg(raIn, offsets[i]);
                ++i;
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    public Set<Integer> seekG(Object target, boolean incEqual) throws DataException {
        Set<Integer> result = new HashSet<Integer>();
        int primaryIndex = DataSetNumberIndex.binarySearch(target, this.boundaryStartingValues, 4);
        if (primaryIndex < 0 || primaryIndex >= this.boundaryStartingValues.size()) {
            return result;
        }
        result = this.segs[primaryIndex].seekG(target, incEqual);
        int i = primaryIndex + 1;
        while (i < this.segs.length) {
            result.addAll(this.segs[i].seekAll());
            ++i;
        }
        return result;
    }

    public Set<Integer> seekL(Object target, boolean incEqual) throws DataException {
        Set<Integer> result = new HashSet<Integer>();
        int primaryIndex = DataSetNumberIndex.binarySearch(target, this.boundaryStartingValues, 4);
        if (primaryIndex < 0 || primaryIndex >= this.boundaryStartingValues.size()) {
            return result;
        }
        result = this.segs[primaryIndex].seekL(target, incEqual);
        int i = 0;
        while (i < primaryIndex) {
            result.addAll(this.segs[i].seekAll());
            ++i;
        }
        return result;
    }

    public Set<Integer> seekEQ(Object target) throws DataException {
        HashSet<Integer> result = new HashSet<Integer>();
        int primaryIndex = DataSetNumberIndex.binarySearch(target, this.boundaryStartingValues, 4);
        if (primaryIndex < 0 || primaryIndex >= this.boundaryStartingValues.size()) {
            return result;
        }
        return this.segs[primaryIndex].seek(target);
    }

    public Set<Integer> seekBetween(Object target1, Object target2) throws DataException {
        int primaryIndex2;
        HashSet<Integer> result = new HashSet<Integer>();
        int primaryIndex1 = DataSetNumberIndex.binarySearch(target1, this.boundaryStartingValues, 4);
        if (primaryIndex1 == (primaryIndex2 = DataSetNumberIndex.binarySearch(target2, this.boundaryStartingValues, 4).intValue()) && primaryIndex1 >= 0 && primaryIndex1 < this.boundaryStartingValues.size()) {
            return this.segs[primaryIndex1].seekBetween(target1, target2);
        }
        if (primaryIndex1 > primaryIndex2) {
            return result;
        }
        result.addAll(this.segs[primaryIndex1].seekG(target1, true));
        result.addAll(this.segs[primaryIndex2].seekL(target2, true));
        int i = primaryIndex1 + 1;
        while (i < primaryIndex2) {
            result.addAll(this.segs[i].seekAll());
            ++i;
        }
        return result;
    }

    private static Integer binarySearch(Object target, List sortedList, int searchOption) throws DataException {
        block18: {
            int high;
            int low;
            block21: {
                block20: {
                    block19: {
                        block17: {
                            low = 0;
                            high = sortedList.size() - 1;
                            int mid = low + high >> 1;
                            while (low <= high) {
                                mid = low + high >> 1;
                                Object midVal = sortedList.get(mid);
                                int cmp = ScriptEvalUtil.compare(midVal, target);
                                if (cmp < 0) {
                                    low = mid + 1;
                                    continue;
                                }
                                if (cmp > 0) {
                                    high = mid - 1;
                                    continue;
                                }
                                if (searchOption != 1 && searchOption != 5 && searchOption != 4) break;
                                return mid;
                            }
                            if (low > high) {
                                int temp = low;
                                low = high;
                                high = temp;
                                if (high >= sortedList.size()) {
                                    high = sortedList.size() - 1;
                                }
                            }
                            if (searchOption != 1) break block17;
                            int i = low;
                            while (i <= high) {
                                if (ScriptEvalUtil.compare(sortedList.get(i), target) == 0) {
                                    return i;
                                }
                                ++i;
                            }
                            break block18;
                        }
                        if (searchOption != 5) break block19;
                        int i = low;
                        while (i <= high) {
                            if (ScriptEvalUtil.compare(sortedList.get(i), target) >= 0) {
                                return i;
                            }
                            ++i;
                        }
                        break block18;
                    }
                    if (searchOption != 4) break block20;
                    int i = high;
                    while (i >= low) {
                        if (ScriptEvalUtil.compare(sortedList.get(i), target) <= 0) {
                            return i;
                        }
                        --i;
                    }
                    break block18;
                }
                if (searchOption != 6) break block21;
                if (high == low) {
                    return high + 1;
                }
                int i = low;
                while (i <= high) {
                    if (ScriptEvalUtil.compare(sortedList.get(i), target) > 0) {
                        return i;
                    }
                    ++i;
                }
                break block18;
            }
            if (searchOption != 3) break block18;
            if (high == low) {
                return high - 1;
            }
            int i = high;
            while (i >= low) {
                if (ScriptEvalUtil.compare(sortedList.get(i), target) < 0) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    @Override
    public Set<Integer> getKeyIndex(Object key, int searchType) throws DataException {
        if (searchType == 1) {
            return this.seekEQ(key);
        }
        if (searchType == 4) {
            return this.seekL(key, true);
        }
        if (searchType == 3) {
            return this.seekL(key, false);
        }
        if (searchType == 5) {
            return this.seekG(key, true);
        }
        if (searchType == 6) {
            return this.seekG(key, false);
        }
        if (searchType == 7) {
            assert (key instanceof List && ((List)key).size() == 2);
            return this.seekBetween(((List)key).get(0), ((List)key).get(1));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportFilter(int filterType) throws DataException {
        return filterType == 7 || filterType == 1 || filterType == 4 || filterType == 3 || filterType == 5 || filterType == 6;
    }

    @Override
    public Object[] getAllKeyValues() throws DataException {
        ArrayList keys = new ArrayList();
        int i = 0;
        while (i < this.segs.length) {
            keys.addAll(this.segs[i].getKeys());
            ++i;
        }
        return keys.toArray();
    }

    @Override
    public Set<Integer> getAllKeyRows() throws DataException {
        HashSet<Integer> rowID = new HashSet<Integer>();
        int i = 0;
        while (i < this.segs.length) {
            List<Set<Integer>> index = this.segs[i].getIndexs();
            int j = 0;
            while (j < index.size()) {
                Iterator<Integer> rowIDiterator = index.get(j).iterator();
                rowID.add(rowIDiterator.next());
                ++j;
            }
            ++i;
        }
        return rowID;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Seg {
        private List keys;
        private List<Set<Integer>> indexs;
        private RAInputStream raIn;
        private long offset;
        private boolean initialized;

        public Seg(RAInputStream raIn, long offset) {
            this.raIn = raIn;
            this.offset = offset;
            this.initialized = false;
        }

        public List getKeys() throws DataException {
            this.init();
            return this.keys;
        }

        public List<Set<Integer>> getIndexs() throws DataException {
            this.init();
            return this.indexs;
        }

        public int getSize() throws DataException {
            this.init();
            return this.keys.size();
        }

        public Set<Integer> seekAll() throws DataException {
            this.init();
            List<Set<Integer>> indexList = this.indexs;
            HashSet<Integer> result = new HashSet<Integer>();
            int i = 0;
            while (i < indexList.size()) {
                result.addAll((Collection<Integer>)indexList.get(i));
                ++i;
            }
            return result;
        }

        public Set<Integer> seekG(Object value, boolean incEqual) throws DataException {
            this.init();
            List keyList = this.keys;
            List<Set<Integer>> indexList = this.indexs;
            int threshHold = DataSetNumberIndex.binarySearch(value, keyList, incEqual ? 5 : 6);
            if (threshHold < 0 || threshHold >= keyList.size()) {
                return new HashSet<Integer>();
            }
            HashSet<Integer> result = new HashSet<Integer>();
            int i = threshHold;
            while (i < keyList.size()) {
                result.addAll((Collection<Integer>)indexList.get(i));
                ++i;
            }
            return result;
        }

        public Set<Integer> seekL(Object value, boolean incEqual) throws DataException {
            this.init();
            List keyList = this.keys;
            List<Set<Integer>> indexList = this.indexs;
            int threshHold = DataSetNumberIndex.binarySearch(value, keyList, incEqual ? 4 : 3);
            if (threshHold < 0 || threshHold >= keyList.size()) {
                return new HashSet<Integer>();
            }
            HashSet<Integer> result = new HashSet<Integer>();
            int i = 0;
            while (i <= threshHold) {
                result.addAll((Collection<Integer>)indexList.get(i));
                ++i;
            }
            return result;
        }

        public Set<Integer> seekBetween(Object value1, Object value2) throws DataException {
            this.init();
            List keyList = this.keys;
            List<Set<Integer>> indexList = this.indexs;
            int threshHold1 = DataSetNumberIndex.binarySearch(value1, keyList, 5);
            int threshHold2 = DataSetNumberIndex.binarySearch(value2, keyList, 4);
            if (threshHold1 > threshHold2) {
                return new HashSet<Integer>();
            }
            HashSet<Integer> result = new HashSet<Integer>();
            int i = threshHold1;
            while (i <= threshHold2) {
                result.addAll((Collection<Integer>)indexList.get(i));
                ++i;
            }
            return result;
        }

        public Set<Integer> seek(Object value) throws DataException {
            this.init();
            List keyList = this.keys;
            List<Set<Integer>> indexList = this.indexs;
            int threshHold = DataSetNumberIndex.binarySearch(value, keyList, 1);
            if (threshHold < 0 || threshHold >= keyList.size()) {
                return new HashSet<Integer>();
            }
            return indexList.get(threshHold);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() throws DataException {
            block7: {
                try {
                    if (this.initialized) break block7;
                    Seg seg = this;
                    synchronized (seg) {
                        if (!this.initialized) {
                            ArrayList<Object> keyList = new ArrayList<Object>();
                            ArrayList<Set<Integer>> indexList = new ArrayList<Set<Integer>>();
                            this.raIn.seek(this.offset);
                            DataInputStream din = new DataInputStream(this.raIn);
                            int size = IOUtil.readInt(this.raIn);
                            int i = 0;
                            while (i < size) {
                                keyList.add(IOUtil.readObject(din));
                                indexList.add(new HashSet(IOUtil.readList(din)));
                                ++i;
                            }
                            this.keys = keyList;
                            this.indexs = indexList;
                            this.initialized = true;
                        }
                    }
                }
                catch (Exception e) {
                    throw new DataException(e.getLocalizedMessage(), e);
                }
            }
        }
    }
}

