/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.aggregation.AggregationUtil;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.timefunction.IParallelPeriod;
import org.eclipse.birt.data.engine.api.timefunction.IPeriodsFunction;
import org.eclipse.birt.data.engine.api.timefunction.ITimeFunction;
import org.eclipse.birt.data.engine.api.timefunction.ReferenceDate;
import org.eclipse.birt.data.engine.api.timefunction.TimeMember;
import org.eclipse.birt.data.engine.api.timefunction.TimePeriodType;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.SizeOfUtil;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.MeasureInfo;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.DimColumn;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.ColumnInfo;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.FacttableRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.ICubeDimensionReader;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.IDataSet4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.MemberCellIndex;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.MemberCellIndexComparator;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.PeriodsToDateWithParallel;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.Row4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.Row4AggregationComparator;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.TimeResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.AbstractMDX;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.TimeFunctionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.TimeMemberUtil;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.DiskSortedStack;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFacttableFilterEvalHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeFunctionCalculator {
    AggregationDefinition aggregation;
    private int timeDimensionIndex = 0;
    private int endLevelIndex = 0;
    private int lowestTimeLevel = 0;
    private int firstTimeLevel = 0;
    private int newMemberSize = 0;
    private int[] measureIndexes;
    private MeasureInfo[] measureInfos;
    private int[] parameterColIndex;
    private FacttableRow facttableRow;
    private Accumulator[][] accumulators;
    private IAggrFunction[] aggregationFunction;
    private DiskSortedStack sortedFactRows;
    private BufferedStructureArray factRows;
    private int factRowPostion;
    private DiskSortedStack[] timeMemberFilters;
    private boolean existTimeFunction;
    private ICubeDimensionReader cubeDimensionReader;
    private IPeriodsFunction[] periodFunction;
    private Map<TimeMember, List<TimeMember>>[] periodFunctionResultCache;
    private String tDimName;
    private IDimension timeDimension;
    private String[] levelType;
    private List<MemberCellIndex>[] currentFilterList;
    private List<Row4Aggregation> currentRowList;
    private MemberCellIndex[] currentFilter;
    private Row4Aggregation currentRow;
    private boolean existReferenceDate;
    private boolean existLastDate;
    private boolean avoidExtraSort;
    private Date[] referenceDate;
    private int orignalLevelCount;
    private int[] sortType;

    TimeFunctionCalculator(AggregationDefinition aggr, DimColumn[] parameterColNames, IDataSet4Aggregation.MetaInfo metaInfo, ICubeDimensionReader cubeDimensionReader, long memoryCacheSize) throws DataException, IOException {
        int rowSize;
        int bufferSize;
        AggregationFunctionDefinition[] timeFunction = aggr.getAggregationTimeFunctions();
        if (timeFunction == null) {
            this.existTimeFunction = false;
            return;
        }
        this.existTimeFunction = true;
        this.tDimName = timeFunction[0].getTimeFunction().getTimeDimension();
        this.timeDimension = cubeDimensionReader.getDimension(this.tDimName);
        this.periodFunction = TimeFunctionCalculator.createTimeFunction(timeFunction);
        this.periodFunctionResultCache = new Map[this.periodFunction.length];
        int i = 0;
        while (i < this.periodFunctionResultCache.length) {
            this.periodFunctionResultCache[i] = new HashMap<TimeMember, List<TimeMember>>();
            ++i;
        }
        this.timeDimensionIndex = cubeDimensionReader.getDimensionIndex(this.tDimName);
        this.lowestTimeLevel = this.getLowestTimeLevel(aggr);
        this.firstTimeLevel = this.getFirstTimeLevel(aggr);
        this.existReferenceDate = false;
        this.existLastDate = false;
        this.referenceDate = new Date[timeFunction.length];
        i = 0;
        while (i < timeFunction.length) {
            if (timeFunction[i].getTimeFunction().getReferenceDate() != null) {
                this.referenceDate[i] = timeFunction[i].getTimeFunction().getReferenceDate().getDate();
            }
            if (this.referenceDate[i] != null) {
                int levelIndex2;
                this.existReferenceDate = true;
                int levelIndex1 = cubeDimensionReader.getlowestLevelIndex(this.tDimName) - 1;
                if (levelIndex1 == (levelIndex2 = cubeDimensionReader.getLevelIndex(this.tDimName, aggr.getLevels()[this.lowestTimeLevel].getLevelName()))) {
                    this.avoidExtraSort = true;
                }
            } else {
                this.existLastDate = true;
            }
            ++i;
        }
        this.endLevelIndex = this.existReferenceDate ? cubeDimensionReader.getlowestLevelIndex(this.tDimName) - 1 : cubeDimensionReader.getLevelIndex(this.tDimName, aggr.getLevels()[this.lowestTimeLevel].getLevelName());
        this.orignalLevelCount = aggr.getLevels().length;
        this.newMemberSize = aggr.getLevels().length - (this.lowestTimeLevel - this.firstTimeLevel + 1) + (this.endLevelIndex + 1);
        this.sortType = this.getSortType(aggr, cubeDimensionReader);
        Comparator comparator = new Row4AggregationComparator(this.sortType);
        int levelCount = 0;
        levelCount = aggr.getLevels() == null ? 0 : aggr.getLevels().length;
        int levelSize = 0;
        if (levelCount != 0) {
            levelSize = this.getLevelSize(metaInfo, aggr.getLevels());
        }
        int measureSize = 0;
        if (this.aggregationFunction != null && this.aggregationFunction.length > 0) {
            measureSize = this.aggregationFunction.length * 64;
        }
        if ((bufferSize = (int)(memoryCacheSize / (long)(rowSize = 16 + (4 + (levelSize + measureSize) - 1) / 8 * 8))) < 100) {
            bufferSize = 100;
        }
        if (this.existReferenceDate) {
            if (!this.avoidExtraSort) {
                this.sortedFactRows = new DiskSortedStack(bufferSize, false, comparator, Row4Aggregation.getCreator());
                if (memoryCacheSize == 0L) {
                    this.sortedFactRows.setUseMemoryOnly(true);
                }
            } else {
                this.factRows = new BufferedStructureArray(Row4Aggregation.getCreator(), bufferSize);
                if (memoryCacheSize == 0L) {
                    this.factRows.setUseMemoryOnly(true);
                }
                this.factRowPostion = 0;
            }
        }
        if (this.existLastDate) {
            this.factRows = new BufferedStructureArray(Row4Aggregation.getCreator(), bufferSize);
            if (memoryCacheSize == 0L) {
                this.factRows.setUseMemoryOnly(true);
            }
            this.factRowPostion = 0;
        }
        comparator = new MemberCellIndexComparator(this.getSortType(aggr, cubeDimensionReader));
        this.timeMemberFilters = new DiskSortedStack[timeFunction.length];
        int i2 = 0;
        while (i2 < this.timeMemberFilters.length) {
            this.timeMemberFilters[i2] = new DiskSortedStack(bufferSize, false, comparator, MemberCellIndex.getCreator());
            if (memoryCacheSize == 0L) {
                this.timeMemberFilters[i2].setUseMemoryOnly(true);
            }
            ++i2;
        }
        this.aggregation = aggr;
        this.measureIndexes = new int[timeFunction.length];
        this.parameterColIndex = new int[timeFunction.length];
        this.aggregationFunction = new IAggrFunction[timeFunction.length];
        i2 = 0;
        while (i2 < timeFunction.length) {
            this.aggregationFunction[i2] = AggregationManager.getInstance().getAggregation(timeFunction[i2].getFunctionName());
            if (this.aggregationFunction[i2] == null) {
                throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.UnsupportedFunction")) + timeFunction[i2].getFunctionName());
            }
            this.parameterColIndex[i2] = AggregationUtil.needDataField(this.aggregationFunction[i2]) ? TimeFunctionCalculator.find(parameterColNames, timeFunction[i2].getParaCol()) : -1;
            String measureName = timeFunction[i2].getMeasureName();
            this.measureIndexes[i2] = metaInfo.getMeasureIndex(measureName);
            if (this.measureIndexes[i2] == -1 && measureName != null) {
                throw new DataException("data.olap.measureNameNotFound", measureName);
            }
            ++i2;
        }
        this.measureInfos = metaInfo.getMeasureInfos();
        this.facttableRow = new FacttableRow(this.measureInfos, cubeDimensionReader, metaInfo);
        this.cubeDimensionReader = cubeDimensionReader;
        this.getLevelType();
    }

    private int getLevelSize(IDataSet4Aggregation.MetaInfo metaInfo, DimLevel[] dimLevel) throws DataException {
        if (dimLevel == null || dimLevel.length == 0) {
            return 0;
        }
        int[] dataType = new int[dimLevel.length];
        int i = 0;
        while (i < dimLevel.length) {
            DimColumn dimColumn = null;
            dimColumn = dimLevel[i].getAttrName() == null ? new DimColumn(dimLevel[i].getDimensionName(), dimLevel[i].getLevelName(), dimLevel[i].getLevelName()) : new DimColumn(dimLevel[i].getDimensionName(), dimLevel[i].getLevelName(), dimLevel[i].getAttrName());
            ColumnInfo columnInfo = metaInfo.getColumnInfo(dimColumn);
            dataType[i] = columnInfo.getDataType();
            ++i;
        }
        return SizeOfUtil.getObjectSize(dataType);
    }

    private void getLevelType() {
        DimLevel[] aggrLevel = this.aggregation.getLevels();
        this.levelType = new String[this.lowestTimeLevel - this.firstTimeLevel + 1];
        ILevel[] level = this.timeDimension.getHierarchy().getLevels();
        int i = this.firstTimeLevel;
        while (i <= this.lowestTimeLevel) {
            int j = 0;
            while (j < level.length) {
                if (aggrLevel[i].getLevelName().equals(level[j].getName())) {
                    this.levelType[i - this.firstTimeLevel] = level[j].getLeveType();
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private static IPeriodsFunction[] createTimeFunction(AggregationFunctionDefinition[] timeFunction) throws DataException {
        IPeriodsFunction[] periodsFunction = new IPeriodsFunction[timeFunction.length];
        String toDatelevelType = null;
        String paralevelType = null;
        int i = 0;
        while (i < periodsFunction.length) {
            ITimeFunction function = timeFunction[i].getTimeFunction();
            toDatelevelType = TimeFunctionCalculator.toLevelType(function.getBaseTimePeriod().getType());
            periodsFunction[i] = function.getBaseTimePeriod().countOfUnit() == 0 ? TimeFunctionFactory.createPeriodsToDateFunction(toDatelevelType, function.getBaseTimePeriod().isCurrent()) : TimeFunctionFactory.createTrailingFunction(toDatelevelType, function.getBaseTimePeriod().countOfUnit());
            ((AbstractMDX)((Object)periodsFunction[i])).setReferenceDate((ReferenceDate)function.getReferenceDate());
            if (function.getRelativeTimePeriod() != null) {
                paralevelType = TimeFunctionCalculator.toLevelType(function.getRelativeTimePeriod().getType());
                IParallelPeriod parallelPeriod = TimeFunctionFactory.createParallelPeriodFunction(paralevelType, function.getRelativeTimePeriod().countOfUnit());
                ((AbstractMDX)((Object)parallelPeriod)).setReferenceDate((ReferenceDate)function.getReferenceDate());
                periodsFunction[i] = new PeriodsToDateWithParallel(parallelPeriod, periodsFunction[i]);
            }
            ++i;
        }
        return periodsFunction;
    }

    private static String toLevelType(TimePeriodType timePeriodType) {
        if (timePeriodType == TimePeriodType.YEAR) {
            return "year";
        }
        if (timePeriodType == TimePeriodType.QUARTER) {
            return "quarter";
        }
        if (timePeriodType == TimePeriodType.MONTH) {
            return "month";
        }
        if (timePeriodType == TimePeriodType.WEEK) {
            return "week-of-year";
        }
        if (timePeriodType == TimePeriodType.DAY) {
            return "day-of-month";
        }
        return null;
    }

    private static int find(DimColumn[] colArray, DimColumn col) {
        if (colArray == null || col == null) {
            return -1;
        }
        int i = 0;
        while (i < colArray.length) {
            if (col.equals(colArray[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int[] getSortType(AggregationDefinition aggregationDef, ICubeDimensionReader cubeDimensionReader) {
        ArrayList<DimLevel> list = new ArrayList<DimLevel>();
        DimLevel[] aggrDimLevel = aggregationDef.getLevels();
        ILevel[] levels = this.timeDimension.getHierarchy().getLevels();
        int i = 0;
        while (i < this.firstTimeLevel) {
            list.add(aggrDimLevel[i]);
            ++i;
        }
        i = 0;
        while (i <= this.endLevelIndex) {
            list.add(new DimLevel(this.tDimName, levels[i].getName()));
            ++i;
        }
        i = this.lowestTimeLevel + 1;
        while (i < aggregationDef.getLevels().length) {
            list.add(aggrDimLevel[i]);
            ++i;
        }
        int[] sortType = new int[list.size()];
        int i2 = 0;
        while (i2 < sortType.length) {
            sortType[i2] = TimeFunctionCalculator.getSortType(aggregationDef, (DimLevel)list.get(i2));
            ++i2;
        }
        return sortType;
    }

    private int getLowestTimeLevel(AggregationDefinition aggregationDef) {
        DimLevel[] levels = aggregationDef.getLevels();
        int index = 0;
        int i = 0;
        while (i < levels.length) {
            if (this.tDimName.equals(levels[i].getDimensionName())) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    private int getFirstTimeLevel(AggregationDefinition aggregationDef) {
        DimLevel[] levels = aggregationDef.getLevels();
        int i = 0;
        while (i < levels.length) {
            if (this.tDimName.equals(levels[i].getDimensionName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int getSortType(AggregationDefinition aggregationDef, DimLevel level) {
        DimLevel[] levels = aggregationDef.getLevels();
        int[] sortTypes = aggregationDef.getSortTypes();
        int i = 0;
        while (i < levels.length) {
            if (levels[i].equals(level)) {
                return sortTypes[i];
            }
            ++i;
        }
        return 0;
    }

    public boolean existTimeFunction() {
        return this.existTimeFunction;
    }

    public void onRow(Row4Aggregation row) throws IOException, DataException {
        Row4Aggregation newRow = new Row4Aggregation();
        if (row.getLevelMembers().length != this.newMemberSize || this.orignalLevelCount != this.newMemberSize) {
            Member[] nMembers = new Member[this.newMemberSize];
            System.arraycopy(row.getLevelMembers(), 0, nMembers, 0, this.firstTimeLevel);
            Member[] timeMember = this.cubeDimensionReader.getLevelMembers(this.timeDimensionIndex, this.endLevelIndex, row.getDimPos()[this.timeDimensionIndex]);
            System.arraycopy(timeMember, 0, nMembers, this.firstTimeLevel, timeMember.length);
            if (this.orignalLevelCount - (this.lowestTimeLevel + 1) > 0) {
                System.arraycopy(row.getLevelMembers(), this.lowestTimeLevel + 1, nMembers, this.firstTimeLevel + timeMember.length, this.orignalLevelCount - (this.lowestTimeLevel + 1));
            }
            newRow.setLevelMembers(nMembers);
            newRow.setDimPos(row.getDimPos());
            newRow.setMeasures(row.getMeasures());
            newRow.setMeasureList(row.getMeasureList());
            newRow.setParameterValues(row.getParameterValues());
        } else {
            newRow = row;
        }
        if (this.existReferenceDate && !this.avoidExtraSort) {
            this.sortedFactRows.push(newRow);
        }
        if (this.existLastDate || this.avoidExtraSort) {
            this.factRows.add(newRow);
        }
    }

    private Row4Aggregation retrieveOneFactRow() throws IOException {
        if (this.factRowPostion >= this.factRows.size()) {
            return null;
        }
        Row4Aggregation row = (Row4Aggregation)this.factRows.get(this.factRowPostion);
        ++this.factRowPostion;
        return row;
    }

    public List<TimeResultRow> getAggregationResultSet(IAggregationResultSet resultSet) throws DataException, IOException {
        this.createCalculator(resultSet.length());
        int i = 0;
        while (i < resultSet.length()) {
            resultSet.seek(i);
            IAggregationResultRow aggrRow = resultSet.getCurrentRow();
            Member[] member = aggrRow.getLevelMembers();
            Member[] nMembers = new Member[this.newMemberSize];
            System.arraycopy(member, 0, nMembers, 0, this.firstTimeLevel);
            if (member.length - (this.lowestTimeLevel + 1) > 0) {
                System.arraycopy(member, this.lowestTimeLevel + 1, nMembers, this.firstTimeLevel + (this.endLevelIndex + 1), member.length - (this.lowestTimeLevel + 1));
            }
            int j = 0;
            while (j < this.periodFunction.length) {
                TimeMember tMember = this.getCurrentMember(this.timeDimension, this.referenceDate[j], member);
                List<TimeMember> validTimeMember = this.periodFunctionResultCache[j].get(tMember);
                if (validTimeMember == null) {
                    validTimeMember = this.periodFunction[j].getResult(tMember);
                    this.periodFunctionResultCache[j].put(tMember, validTimeMember);
                }
                int k = 0;
                while (k < validTimeMember.size()) {
                    Member[] filterMembers = new Member[nMembers.length];
                    System.arraycopy(nMembers, 0, filterMembers, 0, nMembers.length);
                    Member[] timeMember = this.toMember(validTimeMember.get(k));
                    System.arraycopy(timeMember, 0, filterMembers, this.firstTimeLevel, timeMember.length);
                    MemberCellIndex memberCellIndex = new MemberCellIndex(filterMembers, i);
                    this.timeMemberFilters[j].push(memberCellIndex);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.currentFilterList = new List[this.timeMemberFilters.length];
        this.currentFilter = new MemberCellIndex[this.timeMemberFilters.length];
        i = 0;
        while (i < this.timeMemberFilters.length) {
            if (this.referenceDate[i] != null) {
                this.currentFilterList[i] = new ArrayList<MemberCellIndex>();
                this.currentFilter[i] = (MemberCellIndex)this.timeMemberFilters[i].pop();
                this.retrieveFilter(i);
            }
            ++i;
        }
        this.currentRowList = new ArrayList<Row4Aggregation>();
        if (this.existReferenceDate) {
            this.currentRow = this.retrieveOneDetailRow();
            this.retrieveGroupRows(true);
            while (this.currentRowList.size() > 0) {
                i = 0;
                while (i < this.timeMemberFilters.length) {
                    if (this.referenceDate[i] != null && this.currentFilterList[i].size() != 0) {
                        int compareResult = this.compare(this.currentRowList.get(0), this.currentFilterList[i].get(0));
                        while (compareResult > 0) {
                            this.retrieveFilter(i);
                            if (this.currentFilterList[i].size() == 0) break;
                            compareResult = this.compare(this.currentRowList.get(0), this.currentFilterList[i].get(0));
                        }
                        if (compareResult == 0) {
                            this.doCalculate(i);
                        }
                    }
                    ++i;
                }
                this.retrieveGroupRows(true);
            }
        }
        i = 0;
        while (i < this.timeMemberFilters.length) {
            if (this.referenceDate[i] == null) {
                this.currentFilterList[i] = new ArrayList<MemberCellIndex>();
                this.currentFilter[i] = (MemberCellIndex)this.timeMemberFilters[i].pop();
                this.retrieveFilter(i);
            }
            ++i;
        }
        this.currentRowList = new ArrayList<Row4Aggregation>();
        if (this.existLastDate) {
            this.currentRow = this.retrieveOneFactRow();
            this.retrieveGroupRows(false);
            while (this.currentRowList.size() > 0) {
                i = 0;
                while (i < this.timeMemberFilters.length) {
                    if (this.referenceDate[i] == null && this.currentFilterList[i].size() != 0) {
                        int compareResult = this.compare(this.currentRowList.get(0), this.currentFilterList[i].get(0));
                        while (compareResult > 0) {
                            this.retrieveFilter(i);
                            if (this.currentFilterList[i].size() == 0) break;
                            compareResult = this.compare(this.currentRowList.get(0), this.currentFilterList[i].get(0));
                        }
                        if (compareResult == 0) {
                            this.doCalculate(i);
                        }
                    }
                    ++i;
                }
                this.retrieveGroupRows(false);
            }
        }
        ArrayList<TimeResultRow> result = new ArrayList<TimeResultRow>();
        int i2 = 0;
        while (i2 < this.accumulators.length) {
            Object[] value = new Object[this.accumulators[i2].length];
            int j = 0;
            while (j < this.accumulators[i2].length) {
                this.accumulators[i2][j].finish();
                value[j] = this.accumulators[i2][j].getValue();
                ++j;
            }
            result.add(new TimeResultRow(value));
            ++i2;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void doCalculate(int functionIndex) throws DataException {
        i = 0;
        while (i < this.currentRowList.size()) {
            block3: {
                if (this.getFilterResult(this.currentRowList.get(i), functionIndex)) ** GOTO lbl11
                break block3;
lbl-1000:
                // 1 sources

                {
                    para = this.getAccumulatorParameter(this.currentRowList.get(i), functionIndex);
                    j = 0;
                    while (j < this.currentFilterList[functionIndex].size()) {
                        this.accumulators[this.currentFilterList[functionIndex].get((int)j).cellPosition][functionIndex].onRow(para);
                        ++j;
                    }
lbl11:
                    // 2 sources

                    ** while (this.currentRowList.get((int)i).nextMeasures())
                }
lbl12:
                // 1 sources

                this.currentRowList.get(i).firstMeasure();
            }
            ++i;
        }
    }

    private boolean getFilterResult(Row4Aggregation row, int functionNo) throws DataException {
        this.facttableRow.setDimPos(row.getDimPos());
        this.facttableRow.setMeasure(row.getMeasures());
        IJSFacttableFilterEvalHelper filterEvalHelper = this.aggregation.getAggregationTimeFunctions()[functionNo].getFilterEvalHelper();
        if (filterEvalHelper == null) {
            return true;
        }
        return filterEvalHelper.evaluateFilter(this.facttableRow);
    }

    private Object[] getAccumulatorParameter(Row4Aggregation row, int funcIndex) {
        Object[] parameters = null;
        if (this.parameterColIndex[funcIndex] == -1) {
            parameters = new Object[1];
            if (this.measureIndexes[funcIndex] < 0) {
                return null;
            }
            parameters[0] = row.getMeasures()[this.measureIndexes[funcIndex]];
        } else {
            parameters = new Object[]{this.measureIndexes[funcIndex] < 0 ? null : row.getMeasures()[this.measureIndexes[funcIndex]], row.getParameterValues()[this.parameterColIndex[funcIndex]]};
        }
        return parameters;
    }

    private void retrieveFilter(int functionIndex) throws IOException {
        this.currentFilterList[functionIndex].clear();
        if (this.currentFilter[functionIndex] == null) {
            return;
        }
        this.currentFilterList[functionIndex].add(this.currentFilter[functionIndex]);
        MemberCellIndex filter = (MemberCellIndex)this.timeMemberFilters[functionIndex].pop();
        while (filter != null && TimeFunctionCalculator.compare(this.currentFilter[functionIndex], filter) == 0) {
            this.currentFilterList[functionIndex].add(filter);
            filter = (MemberCellIndex)this.timeMemberFilters[functionIndex].pop();
        }
        this.currentFilter[functionIndex] = filter;
    }

    private void retrieveGroupRows(boolean isDetailRow) throws IOException {
        this.currentRowList.clear();
        if (this.currentRow == null) {
            return;
        }
        this.currentRowList.add(this.currentRow);
        Row4Aggregation row = isDetailRow ? this.retrieveOneDetailRow() : this.retrieveOneFactRow();
        while (row != null && TimeFunctionCalculator.compare(this.currentRow, row) == 0) {
            this.currentRowList.add(row);
            row = isDetailRow ? this.retrieveOneDetailRow() : this.retrieveOneFactRow();
        }
        this.currentRow = row;
    }

    private Row4Aggregation retrieveOneDetailRow() throws IOException {
        Row4Aggregation row = null;
        row = !this.avoidExtraSort && this.existReferenceDate ? (Row4Aggregation)this.sortedFactRows.pop() : this.retrieveOneFactRow();
        return row;
    }

    private int compare(Row4Aggregation r, MemberCellIndex m) {
        int result = 0;
        int i = 0;
        while (i < r.getLevelMembers().length) {
            if (m.member[i] != null) {
                result = r.getLevelMembers()[i].compareTo(m.member[i]);
                if (this.sortType[i] == 1) {
                    result *= -1;
                }
                if (result != 0) {
                    return result;
                }
            }
            ++i;
        }
        return 0;
    }

    private static int compare(Row4Aggregation r1, Row4Aggregation r2) {
        int result = 0;
        int i = 0;
        while (i < r1.getLevelMembers().length) {
            result = r1.getLevelMembers()[i].compareTo(r2.getLevelMembers()[i]);
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return 0;
    }

    private static int compare(MemberCellIndex m1, MemberCellIndex m2) {
        int result = 0;
        int i = 0;
        while (i < m1.member.length) {
            if (m1.member[i] != null || m2.member[i] != null) {
                if (m1.member[i] == null) {
                    return -1;
                }
                if (m2.member[i] == null) {
                    return 1;
                }
                result = m1.member[i].compareTo(m2.member[i]);
                if (result != 0) {
                    return result;
                }
            }
            ++i;
        }
        return 0;
    }

    private Member[] toMember(TimeMember tMember) {
        int[] tMemberValues = tMember.getMemberValue();
        Member[] member = new Member[tMemberValues.length];
        int i = 0;
        while (i < tMemberValues.length) {
            member[i] = new Member();
            member[i].setKeyValues(new Integer[]{tMemberValues[i]});
            ++i;
        }
        return member;
    }

    private TimeMember getCellTimeMember(Member[] member) {
        int[] timeMember = new int[this.lowestTimeLevel - this.firstTimeLevel + 1];
        int i = 0;
        while (i < timeMember.length) {
            timeMember[i] = (Integer)member[this.firstTimeLevel + i].getKeyValues()[0];
            ++i;
        }
        return new TimeMember(timeMember, this.levelType);
    }

    private TimeMember getCurrentMember(IDimension timeDimension, Date referenceDate, Member[] member) {
        TimeMember cellTimeMember = this.getCellTimeMember(member);
        if (referenceDate == null) {
            return TimeMemberUtil.getCurrentMember(timeDimension, cellTimeMember);
        }
        return TimeMemberUtil.toMember(timeDimension, referenceDate, cellTimeMember);
    }

    private void createCalculator(int size) throws DataException {
        AggregationFunctionDefinition[] timeFunction = this.aggregation.getAggregationTimeFunctions();
        this.accumulators = new Accumulator[size][];
        int i = 0;
        while (i < size) {
            this.accumulators[i] = new Accumulator[timeFunction.length];
            int j = 0;
            while (j < timeFunction.length) {
                this.accumulators[i][j] = this.aggregationFunction[j].newAccumulator();
                this.accumulators[i][j].start();
                ++j;
            }
            ++i;
        }
    }
}

