/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.dbprofile.impl;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.data.oda.jdbc.Statement;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.impl.ParameterMetaData;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.nls.Messages;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBProfileStatement
extends Statement {
    public static final String CONST_PARAMS_DELIMITER = ";";
    public static final String CONST_PARAM_NAME_DELIMITER = ",";
    public static final String PROP_PRIVATE_PARAMETERMETADATA = "parameterMetaData";
    private Map<Integer, String> m_paramNameMap;

    public DBProfileStatement(Connection connection) throws OdaException {
        super(connection);
    }

    @Override
    public void setProperty(String name, String value) throws OdaException {
        if (name == null) {
            throw new NullPointerException(Messages.bind((String)Messages.dBProfileStatement_nullPropertyNameArg, (Object)"setProperty( String, String )"));
        }
        if (name.equals(PROP_PRIVATE_PARAMETERMETADATA)) {
            if (value != null && value.length() > 0) {
                this.m_paramNameMap = new HashMap<Integer, String>();
                String conditionParams = value;
                String[] params = conditionParams.split(CONST_PARAMS_DELIMITER);
                int i = 0;
                while (i < params.length) {
                    String[] posAndName = params[i].split(CONST_PARAM_NAME_DELIMITER);
                    if (posAndName.length == 2) {
                        this.m_paramNameMap.put(Integer.valueOf(posAndName[0]), posAndName[1]);
                    }
                    ++i;
                }
            }
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public IParameterMetaData getParameterMetaData() throws OdaException {
        IParameterMetaData metaData = super.getParameterMetaData();
        return new ParameterMetaData(metaData, this.getParameterNameMap());
    }

    protected Map<Integer, String> getParameterNameMap() {
        return this.m_paramNameMap;
    }
}

