/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;

public class EngineException
extends BirtException {
    private static final long serialVersionUID = 3137320793453389473L;
    protected static UResourceBundle dftRb = new EngineResourceHandle(ULocale.getDefault()).getUResourceBundle();
    protected static ThreadLocal threadLocal = new ThreadLocal();
    protected static final String pluginId = "org.eclipse.birt.report.engine";
    protected long elementId = -1L;
    protected BirtException birtException;
    protected static HashMap resourceBundles = new HashMap();

    public EngineException(BirtException ex) {
        super(pluginId, ex.getErrorCode(), (ResourceBundle)null, (Throwable)ex);
        this.birtException = ex;
    }

    public EngineException(String errorCode, Object arg0) {
        super(pluginId, errorCode, arg0, (ResourceBundle)EngineException.getResourceBundle());
    }

    public EngineException(String errorCode, Object arg0, Throwable cause) {
        super(pluginId, errorCode, arg0, (ResourceBundle)EngineException.getResourceBundle(), cause);
    }

    public EngineException(String errorCode, Object[] args) {
        super(pluginId, errorCode, args, (ResourceBundle)EngineException.getResourceBundle());
    }

    public EngineException(String errorCode, Object[] args, Throwable cause) {
        super(pluginId, errorCode, args, (ResourceBundle)EngineException.getResourceBundle(), cause);
    }

    public EngineException(String errorCode) {
        super(pluginId, errorCode, (ResourceBundle)EngineException.getResourceBundle());
    }

    public EngineException(String errorCode, Throwable cause) {
        super(pluginId, errorCode, (ResourceBundle)EngineException.getResourceBundle(), cause);
    }

    public static void setULocale(ULocale locale) {
        ULocale rbLocale;
        if (locale == null) {
            return;
        }
        UResourceBundle rb = (UResourceBundle)threadLocal.get();
        if (rb != null && locale.equals((Object)(rbLocale = rb.getULocale()))) {
            return;
        }
        rb = EngineException.getResourceBundle(locale);
        threadLocal.set(rb);
    }

    static UResourceBundle getResourceBundle() {
        UResourceBundle rb = (UResourceBundle)threadLocal.get();
        if (rb == null) {
            return dftRb;
        }
        return rb;
    }

    protected static synchronized UResourceBundle getResourceBundle(ULocale locale) {
        UResourceBundle rb = (UResourceBundle)resourceBundles.get(locale);
        if (rb == null && (rb = new EngineResourceHandle(locale).getUResourceBundle()) != null) {
            resourceBundles.put(locale, rb);
        }
        return rb;
    }

    public void setElementID(long id) {
        this.elementId = id;
    }

    public long getElementID() {
        return this.elementId;
    }

    public String getErrorCode() {
        if (this.birtException != null) {
            return this.birtException.getErrorCode();
        }
        return super.getErrorCode();
    }

    public String getLocalizedMessage() {
        StringBuffer message = new StringBuffer();
        if (this.birtException != null) {
            message.append(this.birtException.getLocalizedMessage());
        } else {
            message.append(super.getLocalizedMessage());
        }
        if (message.length() > 0 && this.elementId >= 0L) {
            message.append(" (");
            message.append(EngineResourceHandle.getInstance().getMessage("Error.ElementID"));
            message.append(":");
            message.append(this.elementId);
            message.append(")");
        }
        return message.toString();
    }

    public String getMessage() {
        return this.getLocalizedMessage();
    }

    public String getPluginId() {
        if (this.birtException != null) {
            return this.birtException.getPluginId();
        }
        return super.getPluginId();
    }

    public int getSeverity() {
        if (this.birtException != null) {
            return this.birtException.getSeverity();
        }
        return super.getSeverity();
    }

    public void setSeverity(int severity) {
        if (this.birtException != null) {
            this.birtException.setSeverity(severity);
        }
        super.setSeverity(severity);
    }
}

