/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;

public class RowContent
extends AbstractContent
implements IRowContent {
    protected int rowID = -1;
    protected String groupId;
    private ITableContent table;
    protected static final short FIELD_ROWID = 800;
    protected static final short FIELD_ROWTYPE = 801;
    protected static final short FIELD_ROW_GROUPLEVEL = 802;
    protected static final short FIELD_ROW_GROUPID = 803;

    RowContent(IRowContent row) {
        super(row);
        this.rowID = row.getRowID();
        this.groupId = row.getGroupId();
    }

    public int getContentType() {
        return 8;
    }

    RowContent(IReportContent report) {
        super(report);
    }

    public Object accept(IContentVisitor visitor, Object value) throws BirtException {
        return visitor.visitRow(this, value);
    }

    public int getRowID() {
        return this.rowID;
    }

    public void setRowID(int rowID) {
        this.rowID = rowID;
    }

    public ITableContent getTable() {
        if (this.table != null) {
            return this.table;
        }
        IContent parent = (IContent)this.getParent();
        while (parent != null) {
            if (parent.getContentType() == 10) {
                this.table = (ITableContent)parent;
                return this.table;
            }
            parent = (IContent)parent.getParent();
        }
        return null;
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.rowID != -1) {
            IOUtil.writeShort(out, (short)800);
            IOUtil.writeInt(out, this.rowID);
        }
        if (this.groupId != null) {
            IOUtil.writeShort(out, (short)803);
            IOUtil.writeString(out, this.groupId);
        }
    }

    public boolean needSave() {
        return true;
    }

    protected void readField(int version, int filedId, DataInputStream in, ClassLoader loader) throws IOException {
        switch (filedId) {
            case 800: {
                this.rowID = IOUtil.readInt(in);
                break;
            }
            case 801: {
                IOUtil.readInt(in);
                break;
            }
            case 802: {
                IOUtil.readInt(in);
                break;
            }
            case 803: {
                this.groupId = IOUtil.readString(in);
                break;
            }
            default: {
                super.readField(version, filedId, in, loader);
            }
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public IGroupContent getGroup() {
        IContent parent;
        IBandContent bandContent = this.getBand();
        if (bandContent != null && (parent = (IContent)bandContent.getParent()) instanceof IGroupContent) {
            return (IGroupContent)parent;
        }
        return null;
    }

    public IBandContent getBand() {
        if (this.parent instanceof IBandContent) {
            return (IBandContent)this.parent;
        }
        return null;
    }

    protected IContent cloneContent() {
        return new RowContent(this);
    }
}

