/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.PDFLayoutEmitter;
import org.eclipse.birt.report.engine.layout.pdf.emitter.TableAreaLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.TableLayout;

public class TableRegionLayout
extends TableLayout {
    IContent layoutContent;

    public TableRegionLayout(LayoutEngineContext context, IContent content, TableLayout.TableLayoutInfo layoutInfo, TableAreaLayout areaLayout) {
        super(context, null, content);
        this.layoutInfo = layoutInfo;
        TableLayout.TableContext tableContext = new TableLayout.TableContext();
        this.contextList.add(tableContext);
        this.currentContext = tableContext;
        tableContext.layout = areaLayout;
    }

    public void initialize(IContent layoutContent) {
        this.layoutContent = layoutContent;
    }

    protected void initialize() {
        this.tableContext = (TableLayout.TableContext)this.currentContext;
        this.createRoot();
        this.currentContext.root.setWidth(this.layoutInfo.getTableWidth());
        this.currentContext.maxAvaWidth = this.layoutInfo.getTableWidth();
        this.currentContext.maxAvaHeight = Integer.MAX_VALUE;
    }

    public TableAreaLayout getTableAreaLayout() {
        return this.tableContext.layout;
    }

    public void layout() throws BirtException {
        this.initialize();
        PDFLayoutEmitter emitter = new PDFLayoutEmitter(this.context);
        emitter.current = this;
        this.visitContent(this.layoutContent, emitter);
        this.closeLayout();
    }

    protected void closeLayout(ContainerLayout.ContainerContext currentContext, int index, boolean finished) {
        currentContext.root.setHeight(currentContext.currentBP + this.getOffsetY());
        this.layoutContent.setExtension(1, currentContext.root);
    }
}

