/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.io.IOException;
import java.util.List;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.util.ElementExporter;
import org.eclipse.birt.report.model.api.util.ElementExporterImpl;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.StructureListValidator;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.core.DesignSessionImpl;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.LibraryUtil;

public class ElementExportUtilImpl {
    public static void exportElement(DesignElementHandle elementToExport, String libraryFileName, boolean canOverride) throws DesignFileException, SemanticException, IOException {
        DesignSessionImpl session = elementToExport.getModule().getSession();
        LibraryHandle libraryHandle = ElementExportUtilImpl.openOrCreateLibrary(session, libraryFileName);
        assert (libraryHandle != null);
        ElementExporter exporter = new ElementExporter(libraryHandle);
        exporter.checkElementToExport(elementToExport, true);
        ElementExportUtilImpl.exportElement(elementToExport, libraryHandle, canOverride);
        libraryHandle.save();
        libraryHandle.close();
    }

    public static void exportElements(List elementsToExport, String libraryFileName, boolean canOverride) throws DesignFileException, SemanticException, IOException {
        if (elementsToExport == null || elementsToExport.isEmpty()) {
            return;
        }
        DesignSessionImpl session = ((DesignElementHandle)elementsToExport.get(0)).getModule().getSession();
        assert (session != null);
        LibraryHandle libraryHandle = ElementExportUtilImpl.openOrCreateLibrary(session, libraryFileName);
        assert (libraryHandle != null);
        ElementExporter exporter = new ElementExporter(libraryHandle);
        for (DesignElementHandle elementToExport : elementsToExport) {
            exporter.checkElementToExport(elementToExport, true);
        }
        for (DesignElementHandle elementToExport : elementsToExport) {
            ElementExportUtilImpl.exportElement(elementToExport, libraryHandle, canOverride);
        }
        libraryHandle.save();
        libraryHandle.close();
    }

    public static void exportElement(DesignElementHandle elementToExport, LibraryHandle targetLibraryHandle, boolean canOverride) throws SemanticException {
        ElementExporter exporter = new ElementExporter(targetLibraryHandle);
        exporter.checkElementToExport(elementToExport, true);
        CommandStack stack = targetLibraryHandle.getCommandStack();
        try {
            stack.startTrans(CommandLabelFactory.getCommandLabel("Message.ExportElementToLibrary"));
            exporter.exportElement(elementToExport, canOverride);
            stack.commit();
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
    }

    public static void exportStyle(StyleHandle styleToExport, ThemeHandle themeHandle, boolean canOverride) throws SemanticException {
        LibraryHandle libraryHandle = (LibraryHandle)themeHandle.getRoot();
        ElementExporter exporter = new ElementExporter(libraryHandle);
        exporter.checkElementToExport(styleToExport, true);
        exporter.exportStyle(styleToExport, themeHandle, canOverride);
    }

    public static void exportStructure(StructureHandle structToExport, String libraryFileName, boolean canOverride) throws DesignFileException, SemanticException, IOException {
        ElementExporter.checkStructureToExport(structToExport, true);
        DesignSessionImpl session = structToExport.getElementHandle().getModule().getSession();
        LibraryHandle libraryHandle = ElementExportUtilImpl.openOrCreateLibrary(session, libraryFileName);
        assert (libraryHandle != null);
        ElementExportUtilImpl.exportStructure(structToExport, libraryHandle, canOverride);
        libraryHandle.save();
        libraryHandle.close();
    }

    public static void exportStructures(List structsToExport, String libraryFileName, boolean canOverride) throws DesignFileException, SemanticException, IOException {
        DesignSessionImpl session = null;
        for (StructureHandle structToExport : structsToExport) {
            ElementExporter.checkStructureToExport(structToExport, true);
            if (session != null) continue;
            session = structToExport.getElementHandle().getModule().getSession();
        }
        if (session == null) {
            return;
        }
        LibraryHandle libraryHandle = ElementExportUtilImpl.openOrCreateLibrary(session, libraryFileName);
        assert (libraryHandle != null);
        for (StructureHandle structToExport : structsToExport) {
            ElementExportUtilImpl.exportStructure(structToExport, libraryHandle, canOverride);
        }
        libraryHandle.save();
        libraryHandle.close();
    }

    public static void exportStructure(StructureHandle structToExport, LibraryHandle targetLibraryHandle, boolean canOverride) throws SemanticException {
        ElementExporter.checkStructureToExport(structToExport, true);
        ElementExporter exporter = new ElementExporter(targetLibraryHandle);
        exporter.exportStructure(structToExport, canOverride);
    }

    public static void exportDesign(ReportDesignHandle designToExport, String libraryFileName, boolean canOverride, boolean genDefaultName) throws DesignFileException, SemanticException, IOException {
        DesignSessionImpl session = designToExport.getModule().getSession();
        LibraryHandle libraryHandle = ElementExportUtilImpl.openOrCreateLibrary(session, libraryFileName);
        assert (libraryHandle != null);
        ElementExportUtilImpl.exportDesign(designToExport, libraryHandle, canOverride, genDefaultName);
        String designVersion = designToExport.getVersion();
        String libVersion = libraryHandle.getVersion();
        if (StringUtil.isBlank(libVersion)) {
            libraryHandle.getModule().getVersionManager().setVersion(designVersion);
        }
        libraryHandle.save();
        libraryHandle.close();
    }

    public static void exportDesign(ReportDesignHandle designToExport, LibraryHandle targetLibraryHandle, boolean canOverride, boolean genDefaultName) throws SemanticException {
        if (LibraryUtil.hasLibrary(designToExport, targetLibraryHandle)) {
            throw new SemanticException(designToExport.getElement(), "Error.LibraryException.LIBRARY_INCLUDED_RECURSIVELY");
        }
        ElementExporter exporter = new ElementExporter(targetLibraryHandle);
        CommandStack stack = targetLibraryHandle.getCommandStack();
        try {
            stack.startTrans(CommandLabelFactory.getCommandLabel("Message.ExportElementToLibrary"));
            exporter.exportDesign(designToExport, canOverride, genDefaultName);
            stack.commit();
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
    }

    private static LibraryHandle openOrCreateLibrary(DesignSessionImpl session, String libraryFileName) throws DesignFileException {
        try {
            Library library = session.openLibrary(libraryFileName);
            return library.handle();
        }
        catch (DesignFileException e) {
            List<ErrorDetail> errorList;
            ErrorDetail error;
            if ("Error.DesignFileException.SYNTAX_ERROR" == e.getErrorCode() && "Error.DesignParserException.FILE_NOT_FOUND" == (error = (errorList = e.getErrorList()).get(0)).getErrorCode()) {
                Library library = session.createLibrary();
                LibraryHandle libraryHandle = library.handle();
                libraryHandle.setFileName(libraryFileName);
                return libraryHandle;
            }
            throw e;
        }
    }

    public static boolean canExport(DesignElementHandle elementToExport, LibraryHandle targetLibraryHandle, boolean canOverride) {
        if (!ElementExportUtilImpl.canExport(elementToExport)) {
            return false;
        }
        if (targetLibraryHandle == null) {
            return false;
        }
        if (elementToExport instanceof ExtendedItemHandle && !ElementExportUtilImpl.checkExportedExtendedItem((ExtendedItemHandle)elementToExport)) {
            return false;
        }
        if (elementToExport instanceof ReportItemHandle || elementToExport instanceof CubeHandle || elementToExport instanceof DataSourceHandle || elementToExport instanceof DataSetHandle || elementToExport instanceof ParameterHandle || elementToExport instanceof ParameterGroupHandle || elementToExport instanceof MasterPageHandle || elementToExport instanceof StyleHandle) {
            return ElementExportUtilImpl.checkExportElementByContext(elementToExport, targetLibraryHandle, canOverride);
        }
        return false;
    }

    protected static final boolean checkExportElementByContext(DesignElementHandle handle, ModuleHandle targetLibraryHandle, boolean canOverride) {
        if (!ElementExportUtilImpl.checkExportableElementByContext(handle.getElement(), targetLibraryHandle, canOverride)) {
            return false;
        }
        ContentIterator iter = new ContentIterator(handle.getModule(), handle.getElement());
        while (iter.hasNext()) {
            DesignElement element = iter.next();
            if (ElementExportUtilImpl.checkExportableElementByContext(element, targetLibraryHandle, canOverride)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkExportableElementByContext(DesignElement element, ModuleHandle targetLibraryHandle, boolean canOverride) {
        String name = element.getName();
        if (name == null) {
            return true;
        }
        if (element instanceof StyleElement) {
            StyleElement style = targetLibraryHandle.getModule().findStyle(name);
            return style == null || canOverride;
        }
        int nameSpaceID = ((ElementDefn)element.getDefn()).getNameSpaceID();
        NameSpace nameSpace = targetLibraryHandle.getModule().getNameHelper().getNameSpace(nameSpaceID);
        DesignElement duplicateElement = nameSpace.getElement(name);
        if (duplicateElement == null) {
            return true;
        }
        DesignElement targetElement = ElementExporterImpl.getDropTarget(duplicateElement);
        if (targetElement == null) {
            return false;
        }
        if (canOverride) {
            return ElementExporterImpl.canDropInContext(targetElement);
        }
        return false;
    }

    public static boolean canExport(StyleHandle styleHandle, ThemeHandle themeHandle, boolean canOverride) {
        if (themeHandle == null) {
            return false;
        }
        if (!ElementExportUtilImpl.canExport(styleHandle)) {
            return false;
        }
        if (canOverride) {
            return true;
        }
        return themeHandle.findStyle(styleHandle.getName()) == null;
    }

    public static boolean canExport(StructureHandle structToExport, LibraryHandle targetLibraryHandle, boolean canOverride) {
        if (!ElementExportUtilImpl.canExport(structToExport)) {
            return false;
        }
        if (targetLibraryHandle == null) {
            return false;
        }
        IElementPropertyDefn propDefn = null;
        String structName = structToExport.getDefn().getName();
        if ("EmbeddedImage".equals(structName)) {
            propDefn = targetLibraryHandle.getPropertyDefn("images");
        } else if ("CustomColor".equals(structName)) {
            propDefn = targetLibraryHandle.getPropertyDefn("colorPalette");
        } else if ("ConfigVar".equals(structName)) {
            propDefn = targetLibraryHandle.getPropertyDefn("configVars");
        } else {
            return false;
        }
        if (canOverride) {
            return true;
        }
        List<SemanticException> results = StructureListValidator.getInstance().validateForAdding(targetLibraryHandle, propDefn, targetLibraryHandle.getListProperty(propDefn.getName()), structToExport.getStructure());
        return results.isEmpty();
    }

    public static boolean canExport(DesignElementHandle elementToExport) {
        return ElementExportUtilImpl.canExport(elementToExport, true);
    }

    public static boolean canExport(StructureHandle structToExport) {
        return ElementExportUtilImpl.canExport(structToExport, true);
    }

    public static boolean canExport(DesignElementHandle elementToExport, boolean ignoreName) {
        if (elementToExport == null) {
            return false;
        }
        ElementExporter exporter = new ElementExporter(new LibraryHandle(new Library(new DesignSession(null))));
        try {
            exporter.checkElementToExport(elementToExport, ignoreName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        if (elementToExport instanceof CubeHandle) {
            return true;
        }
        if (elementToExport instanceof DataSourceHandle) {
            return true;
        }
        if (elementToExport instanceof DataSetHandle) {
            return true;
        }
        if (elementToExport instanceof ParameterHandle || elementToExport instanceof ParameterGroupHandle) {
            return true;
        }
        if (elementToExport instanceof ExtendedItemHandle && !ElementExportUtilImpl.checkExportedExtendedItem((ExtendedItemHandle)elementToExport)) {
            return false;
        }
        if (elementToExport instanceof ReportItemHandle) {
            return true;
        }
        if (elementToExport instanceof MasterPageHandle) {
            return true;
        }
        return elementToExport instanceof StyleHandle;
    }

    public static boolean canExport(StructureHandle structToExport, boolean ignoreName) {
        if (structToExport == null) {
            return false;
        }
        try {
            ElementExporter.checkStructureToExport(structToExport, ignoreName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    private static boolean checkExportedExtendedItem(ExtendedItemHandle elementToExport) {
        try {
            IReportItem item = elementToExport.getReportItem();
            return item == null || item.canExport();
        }
        catch (ExtendedElementException extendedElementException) {
            return false;
        }
    }
}

