/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.ISlotDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefnSet;
import org.eclipse.birt.report.model.validators.ISemanticTriggerDefnSetProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlotDefn
implements ISlotDefn,
ISemanticTriggerDefnSetProvider {
    protected int slotID = -1;
    protected boolean multipleCardinality = true;
    protected String name = null;
    protected String displayNameID = null;
    protected ArrayList<IElementDefn> contentElements = new ArrayList();
    protected ArrayList<String> contentTypes = new ArrayList();
    protected String selector = null;
    protected SemanticTriggerDefnSet triggers = null;
    protected String since;
    protected String xmlName;
    protected boolean isManagedByNameSpace = true;

    @Override
    public boolean isMultipleCardinality() {
        return this.multipleCardinality;
    }

    void setMultipleCardinality(boolean flag) {
        this.multipleCardinality = flag;
    }

    @Override
    public String getDisplayName() {
        assert (this.displayNameID != null);
        return ModelMessages.getMessage(this.displayNameID);
    }

    @Override
    public String getDisplayNameID() {
        return this.displayNameID;
    }

    void setDisplayNameID(String msgID) {
        this.displayNameID = msgID;
    }

    @Override
    public int getSlotID() {
        return this.slotID;
    }

    void setSlotID(int id) {
        this.slotID = id;
    }

    @Override
    public List<IElementDefn> getContentElements() {
        return new ArrayList<IElementDefn>(this.contentElements);
    }

    @Override
    public List<IElementDefn> getContentExtendedElements() {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        IElementDefn extendItem = dd.getElement("ExtendedItem");
        ArrayList<IElementDefn> contentsWithExtensions = new ArrayList<IElementDefn>();
        contentsWithExtensions.addAll(this.contentElements);
        if (this.contentElements.contains(extendItem)) {
            contentsWithExtensions.remove(extendItem);
            int i = 0;
            while (i < dd.getExtensions().size()) {
                ExtensionElementDefn extension = (ExtensionElementDefn)dd.getExtensions().get(i);
                if (extension.isKindOf(dd.getElement("ReportItem")) && "org.eclipse.birt.report.model.reportItemModel".equals(extension.extensionPoint) && !contentsWithExtensions.contains(extension)) {
                    contentsWithExtensions.add(extension);
                }
                ++i;
            }
        }
        return contentsWithExtensions;
    }

    protected void build() throws MetaDataException {
        if (this.contentTypes.isEmpty()) {
            throw new MetaDataException(new String[]{this.name}, "MISSING_SLOT_TYPE");
        }
        if (this.displayNameID == null) {
            throw new MetaDataException(new String[]{this.name}, "MISSING_SLOT_NAME");
        }
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        this.contentElements.clear();
        for (String name : this.contentTypes) {
            ElementDefn type = (ElementDefn)dd.getElement(name);
            if (type == null) {
                throw new MetaDataException(new String[]{name, this.name}, "INVALID_SLOT_TYPE");
            }
            this.contentElements.add(type);
        }
        this.getTriggerDefnSet().build();
    }

    @Override
    public final boolean canContain(IElementDefn type) {
        if (type == null) {
            return false;
        }
        for (ElementDefn elementDefn : this.contentElements) {
            ExtensionElementDefn extensionDefn;
            if (!"ExtendedItem".equals(elementDefn.getName())) {
                if (!type.isKindOf(elementDefn)) continue;
                return true;
            }
            if (type instanceof ExtensionElementDefn && "org.eclipse.birt.report.model.reportItemModel".equals((extensionDefn = (ExtensionElementDefn)type).getExtensionPoint()) && extensionDefn.isKindOf(MetaDataDictionary.getInstance().getElement("ReportItem"))) {
                return true;
            }
            if (!"ExtendedItem".equals(type.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean canContain(DesignElement content) {
        return this.canContain(content.getDefn());
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    void addType(String type) {
        if (!this.contentTypes.contains(type)) {
            this.contentTypes.add(type);
        }
    }

    public String getDefaultStyle() {
        return null;
    }

    void setSelector(String value) {
        this.selector = value;
    }

    @Override
    public String getSelector() {
        return this.selector;
    }

    @Override
    public SemanticTriggerDefnSet getTriggerDefnSet() {
        if (this.triggers == null) {
            this.triggers = new SemanticTriggerDefnSet();
        }
        return this.triggers;
    }

    public void setSince(String value) {
        this.since = value;
    }

    @Override
    public String getSince() {
        return this.since;
    }

    @Override
    public String getXmlName() {
        return this.xmlName;
    }

    public void setXmlName(String value) {
        this.xmlName = value;
    }

    public String toString() {
        if (!StringUtil.isBlank(this.getName())) {
            return this.getName();
        }
        return super.toString();
    }

    public boolean isManagedByNameSpace() {
        return this.isManagedByNameSpace;
    }

    public void setManagedByNameSpace(boolean isManagedByNameSpace) {
        this.isManagedByNameSpace = isManagedByNameSpace;
    }

    @Override
    public List<IElementDefn> getAllowedElements() {
        return this.getAllowedElements(true);
    }

    @Override
    public List<IElementDefn> getAllowedElements(boolean extractExtensions) {
        if (extractExtensions) {
            return this.getContentExtendedElements();
        }
        return this.getContentElements();
    }
}

