/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.elements.structures.CachedMetaData;
import org.eclipse.birt.report.model.api.elements.structures.LevelAttribute;
import org.eclipse.birt.report.model.api.elements.structures.OdaLevelAttribute;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.namespace.ModuleNameHelper;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.OdaLevel;
import org.eclipse.birt.report.model.elements.olap.TabularCube;
import org.eclipse.birt.report.model.elements.olap.TabularHierarchy;
import org.eclipse.birt.report.model.elements.olap.TabularLevel;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ReportElementState;
import org.xml.sax.SAXException;

public abstract class LevelState
extends ReportElementState {
    public LevelState(ModuleParserHandler handler, DesignElement theContainer, String prop) {
        super(handler, theContainer, prop);
    }

    public void end() throws SAXException {
        super.end();
        if (this.handler.versionNumber < 3021300) {
            ((ModuleNameHelper)this.handler.module.getNameHelper()).addCachedLevel(this.getElement());
        }
        if (this.handler.versionNumber < 3022300 && this.getElement().getProperty(this.handler.module, "dateTimeLevelType") != null) {
            boolean isFound = false;
            ElementPropertyDefn attributesPropertyDefn = this.getElement().getPropertyDefn("attributes");
            List attrs = (List)this.getElement().getProperty(this.handler.module, attributesPropertyDefn);
            if (attrs != null) {
                int i = 0;
                while (i < attrs.size()) {
                    LevelAttribute attr = (LevelAttribute)attrs.get(i);
                    if ("DateTime".equals(attr.getName())) {
                        isFound = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!isFound) {
                LevelAttribute attribute;
                LevelAttribute struct = null;
                if (this.getElement() instanceof TabularLevel) {
                    attribute = new LevelAttribute();
                    attribute.setName("DateTime");
                    attribute.setDataType(this.getDataType((TabularLevel)this.getElement()));
                    struct = attribute;
                } else if (this.getElement() instanceof OdaLevel) {
                    attribute = new OdaLevelAttribute();
                    attribute.setName("DateTime");
                    attribute.setDataType("date-time");
                    struct = attribute;
                }
                if (attributesPropertyDefn != null && struct != null) {
                    ArrayList<LevelAttribute> list = new ArrayList<LevelAttribute>();
                    list.add(struct);
                    this.getElement().setProperty(attributesPropertyDefn, list);
                }
            }
        }
    }

    private String getDataType(TabularLevel level) {
        String columnName = level.getStringProperty(this.handler.module, "columnName");
        if (!StringUtil.isBlank(columnName)) {
            List resultSet;
            CachedMetaData metaData;
            DesignElement container = this.getElement().getContainer();
            DataSet dataSet = null;
            if (container instanceof TabularHierarchy) {
                dataSet = (DataSet)container.getReferenceProperty(this.handler.module, "dataSet");
            }
            if (dataSet == null && container != null) {
                if ((container = container.getContainer()) instanceof Dimension) {
                    container = container.getContainer();
                }
                if (container instanceof TabularCube) {
                    dataSet = (DataSet)container.getReferenceProperty(this.handler.module, "dataSet");
                }
            }
            if (dataSet != null && (metaData = (CachedMetaData)dataSet.getProperty(this.handler.module, "cachedMetaData")) != null && (resultSet = (List)metaData.getProperty(this.handler.module, "resultSet")) != null) {
                for (ResultSetColumn column : resultSet) {
                    if (!columnName.equals(column.getStringProperty(this.handler.module, "name"))) continue;
                    String dataType = column.getStringProperty(this.handler.module, "dataType");
                    if (dataType == null) break;
                    return dataType;
                }
            }
        }
        return "date-time";
    }
}

