/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.maven;

import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class ExceptionHandler {
    private final Log log;
    private final boolean continueOnFail;

    public ExceptionHandler(Log log, boolean continueOnFail) {
        this.log = log;
        this.continueOnFail = continueOnFail;
    }

    public void handleError(String msg) throws MojoExecutionException {
        if (!this.continueOnFail) {
            throw new MojoExecutionException("[" + new Date() + "] " + msg);
        }
        this.log.warn((CharSequence)("[" + new Date() + "] " + msg));
    }

    public void handleError(String msg, Exception e) throws MojoExecutionException {
        if (!this.continueOnFail) {
            throw new MojoExecutionException("[" + new Date() + "] " + msg, e);
        }
        this.log.warn((CharSequence)("[" + new Date() + "] " + msg), (Throwable)e);
    }
}

