/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.maven.http;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Objects;
import org.eclipse.cbi.maven.Logger;
import org.eclipse.cbi.maven.http.CompletionListener;
import org.eclipse.cbi.maven.http.HttpResult;

public abstract class AbstractCompletionListener
implements CompletionListener {
    private final Logger log;
    private final Path errorLogFolder;
    private final String erroLogPrefix;
    private final String errorLogSuffix;

    public AbstractCompletionListener(Path errorLogFolder, String errologPrefix, String errorLogSuffix, Logger log) {
        Preconditions.checkArgument((boolean)Files.isDirectory(errorLogFolder, new LinkOption[0]));
        this.errorLogFolder = errorLogFolder;
        this.erroLogPrefix = errologPrefix;
        this.errorLogSuffix = errorLogSuffix;
        this.log = Objects.requireNonNull(log);
    }

    @Override
    public void onError(HttpResult error) {
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP request failed.").append(System.lineSeparator());
        try {
            Path errorMessagePath = Files.createTempFile(this.errorLogFolder, this.erroLogPrefix + "-", "-" + this.errorLogSuffix + ".log", new FileAttribute[0]);
            error.copyContent(errorMessagePath, StandardCopyOption.REPLACE_EXISTING);
            sb.append(this.logErrorMessage(error, errorMessagePath, 25));
        }
        catch (IOException e) {
            this.log.debug("An error occured while reading the server response", e);
            sb.append("HTTP Error " + error.statusCode() + " (reason: " + error.reason() + ")").append(System.lineSeparator());
        }
        this.log.warn("[" + new Date() + "] " + sb.toString());
    }

    private String logErrorMessage(HttpResult error, Path errorMessagePath, int maxLine) {
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP Error " + error.statusCode() + " (reason: " + error.reason() + ")").append(System.lineSeparator());
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(Files.newInputStream(errorMessagePath, new OpenOption[0])), error.contentCharset()));){
            sb.append(this.readLines(reader, maxLine, errorMessagePath));
        }
        catch (IOException e) {
            this.log.debug("An error occured while reading the server response", e);
        }
        return sb.toString();
    }

    private String readLines(BufferedReader reader, int maxLine, Path errorMessagePath) throws IOException {
        StringBuilder sb = new StringBuilder();
        String line = reader.readLine();
        for (int i = 0; i < maxLine && line != null; ++i) {
            sb.append(line);
            sb.append(System.lineSeparator());
            line = reader.readLine();
        }
        if (line != null) {
            sb.append("...<troncated output>... For complete output, see '" + errorMessagePath.toAbsolutePath().toString() + "'");
        } else {
            sb.append("Server response has been saved to '" + errorMessagePath.toAbsolutePath().toString() + "'");
        }
        return sb.toString();
    }
}

