/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.maven.http;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import org.eclipse.cbi.maven.http.AutoValue_HttpRequest_Config;

public final class HttpRequest {
    private final URI serverUri;
    private final ImmutableMap<String, String> stringParams;
    private final ImmutableMap<String, Path> pathParams;

    HttpRequest(URI serverUri, ImmutableMap<String, String> stringParams, ImmutableMap<String, Path> pathParams) {
        this.serverUri = Objects.requireNonNull(serverUri);
        this.stringParams = Objects.requireNonNull(stringParams);
        this.pathParams = Objects.requireNonNull(pathParams);
    }

    public Map<String, Path> pathParameters() {
        return this.pathParams;
    }

    public Map<String, String> stringParameters() {
        return this.stringParams;
    }

    public URI serverUri() {
        return this.serverUri;
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this).add("serverUri", (Object)this.serverUri());
        for (Map.Entry<String, Path> entry : this.pathParameters().entrySet()) {
            toStringHelper.add(entry.getKey(), (Object)("@" + entry.getValue().toString()));
        }
        for (Map.Entry<String, Object> entry : this.stringParameters().entrySet()) {
            toStringHelper.add(entry.getKey(), entry.getValue());
        }
        return toStringHelper.toString();
    }

    public static Builder on(URI serverUri) {
        return new Builder().serverUri(serverUri);
    }

    public static class Builder {
        private URI serverUri;
        private final ImmutableMap.Builder<String, String> stringParams = ImmutableMap.builder();
        private final ImmutableMap.Builder<String, Path> pathParams = ImmutableMap.builder();

        Builder() {
        }

        Builder serverUri(URI serverUri) {
            this.serverUri = Objects.requireNonNull(serverUri);
            return this;
        }

        public Builder withParam(String name, Path path) {
            Preconditions.checkArgument((!Objects.requireNonNull(name).isEmpty() ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)Files.isRegularFile(path, new LinkOption[0]));
            this.pathParams.put((Object)name, (Object)path);
            return this;
        }

        public Builder withParam(String name, String value) {
            Preconditions.checkArgument((!Objects.requireNonNull(name).isEmpty() ? 1 : 0) != 0);
            this.stringParams.put((Object)name, (Object)value);
            return this;
        }

        public HttpRequest build() {
            return new HttpRequest(this.serverUri, (ImmutableMap<String, String>)this.stringParams.build(), (ImmutableMap<String, Path>)this.pathParams.build());
        }
    }

    @AutoValue
    public static abstract class Config {
        private static final Duration CONNECT_TIMEOUT__DEFAULT = Duration.ofSeconds(5L);
        private static final Duration TIMEOUT__DEFAULT;
        private static final Duration READ_TIMEOUT__DEFAULT;

        Config() {
        }

        public abstract Duration connectTimeout();

        public abstract Duration readTimeout();

        public abstract Duration timeout();

        public static Builder builder() {
            return new AutoValue_HttpRequest_Config.Builder().connectTimeout(CONNECT_TIMEOUT__DEFAULT).readTimeout(READ_TIMEOUT__DEFAULT).timeout(TIMEOUT__DEFAULT);
        }

        public static Config defaultConfig() {
            return Config.builder().build();
        }

        static {
            READ_TIMEOUT__DEFAULT = TIMEOUT__DEFAULT = Duration.ZERO;
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder connectTimeout(Duration var1);

            public abstract Builder readTimeout(Duration var1);

            public abstract Builder timeout(Duration var1);

            public abstract Config build();
        }
    }
}

