/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.maven.http;

import com.google.auto.value.AutoValue;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.eclipse.cbi.maven.Logger;
import org.eclipse.cbi.maven.http.AutoValue_RetryHttpClient;
import org.eclipse.cbi.maven.http.CompletionListener;
import org.eclipse.cbi.maven.http.HttpClient;
import org.eclipse.cbi.maven.http.HttpRequest;

@AutoValue
public abstract class RetryHttpClient
implements HttpClient {
    abstract int maxRetries();

    abstract long retryInterval();

    abstract TimeUnit retryIntervalUnit();

    abstract HttpClient delegate();

    abstract Logger log();

    RetryHttpClient() {
    }

    @Override
    public boolean send(HttpRequest request, CompletionListener completionListener) throws IOException {
        return this.send(request, HttpRequest.Config.defaultConfig(), completionListener);
    }

    @Override
    public boolean send(HttpRequest request, HttpRequest.Config config, CompletionListener completionListener) throws IOException {
        boolean sucess = false;
        Exception lastThrownException = null;
        for (int attemptCount = 0; !sucess && attemptCount <= this.maxRetries(); ++attemptCount) {
            if (!sucess && attemptCount > 0) {
                try {
                    if (lastThrownException != null) {
                        this.log().warn("An exception has been thrown, but the request will be retried (attempt " + attemptCount + " / " + this.maxRetries() + ")", lastThrownException);
                        lastThrownException = null;
                    } else {
                        this.log().debug("The previous request did not complete sucessfully, but it will be retried (attempt " + attemptCount + " / " + this.maxRetries() + ")");
                    }
                    this.retryIntervalUnit().sleep(this.retryInterval());
                }
                catch (InterruptedException e) {
                    this.log().warn("Thread '" + Thread.currentThread().getName() + "' has been interrupted", e);
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            try {
                sucess = this.delegate().send(request, config, completionListener);
                continue;
            }
            catch (Exception e) {
                lastThrownException = e;
            }
        }
        if (lastThrownException != null) {
            Throwables.throwIfInstanceOf(lastThrownException, IOException.class);
            Throwables.throwIfUnchecked(lastThrownException);
            throw new RuntimeException(lastThrownException);
        }
        return sucess;
    }

    public static Builder retryRequestOn(HttpClient client) {
        return new AutoValue_RetryHttpClient.Builder().delegate(client);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder maxRetries(int var1);

        abstract Builder retryInterval(long var1);

        abstract Builder retryIntervalUnit(TimeUnit var1);

        public Builder waitBeforeRetry(long retryInterval, TimeUnit retryIntervalUnit) {
            return this.retryInterval(retryInterval).retryIntervalUnit(retryIntervalUnit);
        }

        abstract Builder delegate(HttpClient var1);

        public abstract Builder log(Logger var1);

        abstract RetryHttpClient autoBuild();

        public HttpClient build() {
            RetryHttpClient ret = this.autoBuild();
            Builder.checkPositive(ret.maxRetries(), "'maxRetries' must be positive");
            Builder.checkPositive(ret.retryInterval(), "'retryInterval' must be positive");
            return ret;
        }

        private static long checkPositive(long n, String msg) {
            if (n < 0L) {
                throw new IllegalArgumentException(msg);
            }
            return n;
        }
    }
}

